# frozen_string_literal: true

#
# Copyright (C) 2012 - present Instructure, Inc.
#
# This file is part of Canvas.
#
# Canvas is free software: you can redistribute it and/or modify it under
# the terms of the GNU Affero General Public License as published by the Free
# Software Foundation, version 3 of the License.
#
# Canvas is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
# details.
#
# You should have received a copy of the GNU Affero General Public License along
# with this program. If not, see <http://www.gnu.org/licenses/>.

require File.expand_path(File.dirname(__FILE__) + '/../common')

describe "Authentication Providers" do
  include_context "in-process server selenium tests"
  context "Server errors " do

    it "should show the error message generated by the server" do
      site_admin_logged_in
      Account.default.authentication_providers.create!({
                                                                :auth_host => "blah.blah",
                                                                :auth_over_tls => false,
                                                                :auth_port => "123",
                                                                :auth_type => "ldap",
                                                            })
      get "/accounts/#{Account.default.id}/authentication_providers"
      f(".test_ldap_link").click
      wait_for_ajaximations
      expect(f("#ldap_connection_help .server_error").text).to eq "Unknown host: blah.blah"
    end
  end
end
