# frozen_string_literal: true

#
# Copyright (C) 2011 - present Instructure, Inc.
#
# This file is part of Canvas.
#
# Canvas is free software: you can redistribute it and/or modify it under
# the terms of the GNU Affero General Public License as published by the Free
# Software Foundation, version 3 of the License.
#
# Canvas is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
# details.
#
# You should have received a copy of the GNU Affero General Public License along
# with this program. If not, see <http://www.gnu.org/licenses/>.
#

require File.expand_path(File.dirname(__FILE__) + '/../../spec_helper.rb')

describe Canvas::Plugin do
  describe '.value_to_boolean' do
    it "accepts 0/1 as strings" do
      expect(Canvas::Plugin.value_to_boolean('0')).to eq false
      expect(Canvas::Plugin.value_to_boolean('1')).to eq true
    end

    it "accepts t/f" do
      expect(Canvas::Plugin.value_to_boolean('f')).to eq false
      expect(Canvas::Plugin.value_to_boolean('t')).to eq true
    end
  end
end
