# frozen_string_literal: true

#
# Copyright (C) 2019 - present Instructure, Inc.
#
# This file is part of Canvas.
#
# Canvas is free software: you can redistribute it and/or modify it under the
# terms of the GNU Affero General Public License as published by the Free
# Software Foundation, version 3 of the License.
#
# Canvas is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
# details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

require_relative "../helpers/graphql_type_tester"

module GraphQLSpecHelper
  def gql_arguments(*args, **options)
    (args + options.map{|k, v| "#{k.to_s.camelize(:lower)}: #{v.to_json}" }).join(', ')
  end
end

# building the schema is currently very slow.
# this ensures the schema is built before specs are run to avoid timeouts
CanvasSchema.graphql_definition
