/*
 * Copyright (C) 2018 - present Instructure, Inc.
 *
 * This file is part of Canvas.
 *
 * Canvas is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License as published by the Free
 * Software Foundation, version 3 of the License.
 *
 * Canvas is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 */

import ar from '@instructure/translations/lib/canvas-rce/ar.json'
import bg from '@instructure/translations/lib/canvas-rce/bg.json'
import ca from '@instructure/translations/lib/canvas-rce/ca.json'
import cs from '@instructure/translations/lib/canvas-rce/cs.json'
import cy from '@instructure/translations/lib/canvas-rce/cy.json'
import da from '@instructure/translations/lib/canvas-rce/da.json'
import da_K12 from '@instructure/translations/lib/canvas-rce/da-x-k12.json'
import de from '@instructure/translations/lib/canvas-rce/de.json'
import el from '@instructure/translations/lib/canvas-rce/el.json'
import en_AU from '@instructure/translations/lib/canvas-rce/en_AU.json'
import en_AU_Unimelb from '@instructure/translations/lib/canvas-rce/en-AU-x-unimelb.json'
import en_CY from '@instructure/translations/lib/canvas-rce/en_CY.json'
import en_GB from '@instructure/translations/lib/canvas-rce/en_GB.json'
import en_IE from '@instructure/translations/lib/canvas-rce/en_IE'
import es from '@instructure/translations/lib/canvas-rce/es.json'
import fa from '@instructure/translations/lib/canvas-rce/fa.json'
import fa_IR from '@instructure/translations/lib/canvas-rce/fa_IR.json'
import fr from '@instructure/translations/lib/canvas-rce/fr.json'
import fr_CA from '@instructure/translations/lib/canvas-rce/fr_CA.json'
import he from '@instructure/translations/lib/canvas-rce/he.json'
import ht from '@instructure/translations/lib/canvas-rce/ht.json'
import hu from '@instructure/translations/lib/canvas-rce/hu.json'
import hy from '@instructure/translations/lib/canvas-rce/hy.json'
import is from '@instructure/translations/lib/canvas-rce/is.json'
import it from '@instructure/translations/lib/canvas-rce/it.json'
import ja from '@instructure/translations/lib/canvas-rce/ja.json'
import ko from '@instructure/translations/lib/canvas-rce/ko.json'
import mi from '@instructure/translations/lib/canvas-rce/mi.json'
import nb from '@instructure/translations/lib/canvas-rce/nb.json'
import nb_K12 from '@instructure/translations/lib/canvas-rce/nb-x-k12.json'
import nl from '@instructure/translations/lib/canvas-rce/nl.json'
import nn from '@instructure/translations/lib/canvas-rce/nn.json'
import pl from '@instructure/translations/lib/canvas-rce/pl.json'
import pt from '@instructure/translations/lib/canvas-rce/pt.json'
import pt_BR from '@instructure/translations/lib/canvas-rce/pt_BR.json'
import ro from '@instructure/translations/lib/canvas-rce/ro.json'
import ru from '@instructure/translations/lib/canvas-rce/ru.json'
import sq from '@instructure/translations/lib/canvas-rce/sq.json'
import sr from '@instructure/translations/lib/canvas-rce/sr.json'
import sv from '@instructure/translations/lib/canvas-rce/sv.json'
import sv_K12 from '@instructure/translations/lib/canvas-rce/sv-x-k12.json'
import tr from '@instructure/translations/lib/canvas-rce/tr.json'
import uk from '@instructure/translations/lib/canvas-rce/uk_UA.json'
import vi from '@instructure/translations/lib/canvas-rce/vi.json'
import zh from '@instructure/translations/lib/canvas-rce/zh.json'
import zh_HK from '@instructure/translations/lib/canvas-rce/zh_HK.json'

export default {
  ar,
  bg,
  ca,
  cs,
  cy,
  da,
  'da-x-k12': da_K12,
  de,
  'en-AU': en_AU,
  'en-AU-x-unimelb': en_AU_Unimelb,
  'en-GB': en_GB,
  'en-GB-x-lbs': en_IE,
  'en-GB-x-ukhe': en_CY,
  el,
  es,
  fa,
  'fa-IR': fa_IR,
  fr,
  'fr-CA': fr_CA,
  he,
  ht,
  hu,
  hy,
  is,
  it,
  ja,
  ko,
  mi,
  nb,
  'nb-x-k12': nb_K12,
  nl,
  nn,
  pl,
  'pt-BR': pt_BR,
  pt,
  ro,
  ru,
  sq,
  sr,
  'sv-x-k12': sv_K12,
  sv,
  tr,
  uk,
  vi,
  'zh-Hans': zh,
  'zh-Hant': zh_HK
}
