/*
 * Copyright (C) 2017 - present Instructure, Inc.
 *
 * This file is part of Canvas.
 *
 * Canvas is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License as published by the Free
 * Software Foundation, version 3 of the License.
 *
 * Canvas is distributed in the hope that they will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 */
import ar from '@instructure/translations/lib/canvas-planner/ar.json'
import da from '@instructure/translations/lib/canvas-planner/da.json'
import de from '@instructure/translations/lib/canvas-planner/de.json'
import el from '@instructure/translations/lib/canvas-planner/el.json'
import enAU from '@instructure/translations/lib/canvas-planner/en_AU.json'
import enGB from '@instructure/translations/lib/canvas-planner/en_GB.json'
import en from '@instructure/translations/lib/canvas-planner/en.json'
import es from '@instructure/translations/lib/canvas-planner/es.json'
import faIR from '@instructure/translations/lib/canvas-planner/fa_IR.json'
import frCA from '@instructure/translations/lib/canvas-planner/fr_CA.json'
import fr from '@instructure/translations/lib/canvas-planner/fr.json'
import he from '@instructure/translations/lib/canvas-planner/he.json'
import ht from '@instructure/translations/lib/canvas-planner/ht.json'
import hu from '@instructure/translations/lib/canvas-planner/hu.json'
import hy from '@instructure/translations/lib/canvas-planner/hy.json'
import it from '@instructure/translations/lib/canvas-planner/it.json'
import ja from '@instructure/translations/lib/canvas-planner/ja.json'
import ko from '@instructure/translations/lib/canvas-planner/ko.json'
import mi from '@instructure/translations/lib/canvas-planner/mi.json'
import nl from '@instructure/translations/lib/canvas-planner/nl.json'
import nn from '@instructure/translations/lib/canvas-planner/nn.json'
import pl from '@instructure/translations/lib/canvas-planner/pl.json'
import ptBR from '@instructure/translations/lib/canvas-planner/pt_BR.json'
import pt from '@instructure/translations/lib/canvas-planner/pt.json'
import ru from '@instructure/translations/lib/canvas-planner/ru.json'
import sv from '@instructure/translations/lib/canvas-planner/sv.json'
import tr from '@instructure/translations/lib/canvas-planner/tr.json'
import ukUA from '@instructure/translations/lib/canvas-planner/uk_UA.json'
import zhHans from '@instructure/translations/lib/canvas-planner/zh.json'
import zhHant from '@instructure/translations/lib/canvas-planner/zh_HK.json'
import {flipAll} from './flip-message'

export default {
  enflip: flipAll(en),
  ar,
  da,
  de,
  el,
  'en-au': enAU,
  'en-gb': enGB,
  en,
  es,
  'fa-ir': faIR,
  'fr-ca': frCA,
  fr,
  he,
  ht,
  hu,
  hy,
  it,
  ja,
  ko,
  mi,
  nl,
  nn,
  pl,
  'pt-br': ptBR,
  pt,
  ru,
  sv,
  tr,
  'uk-ua': ukUA,
  'zh-cn': zhHans,
  'zh-tw': zhHant
}
