/*
 * Copyright (C) 2017 - present Instructure, Inc.
 *
 * This file is part of Canvas.
 *
 * Canvas is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License as published by the Free
 * Software Foundation, version 3 of the License.
 *
 * Canvas is distributed in the hope that they will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 */

module.exports = {
  transform: {
    '^.+\\.(js)$': 'babel-jest',
    '^.+\\.(css)$': '<rootDir>/jest-themeable-styles'
  },
  reporters: [
    'default',
    [
      'jest-junit',
      {
        suiteName: 'Canvas Planner Jest Tests',
        outputDirectory: './coverage',
        outputName: 'canvas-planner-junit.xml'
      }
    ]
  ],
  snapshotSerializers: ['enzyme-to-json/serializer'],
  setupFiles: ['jest-canvas-mock', './jest-env.js'],
  testPathIgnorePatterns: ['<rootDir>/node_modues', '<rootDir>/lib'],
  testRegex: '/__tests__/.*\\.(test|spec)\\.js$',
  coverageReporters: ['html', 'text', 'json'],
  collectCoverageFrom: ['src/**/*.js'],
  coveragePathIgnorePatterns: ['<rootDir>/src/i18n/flip-message.js'],
  coverageThreshold: {
    global: {
      branches: 85,
      functions: 85,
      lines: 85,
      statements: 85
    }
  },
  testEnvironment: 'jest-environment-jsdom-fourteen'
}
