/*
 * Copyright (C) 2019 - present Instructure, Inc.
 *
 * This file is part of Canvas.
 *
 * Canvas is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License as published by the Free
 * Software Foundation, version 3 of the License.
 *
 * Canvas is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 */

import React from 'react'

const RocketSVG = props => (
  <svg id="filedrop-rocket_svg__Layer_1" data-name="Layer 1" viewBox="0 0 182 182" {...props}>
    <defs>
      <style>
        {
          '.filedrop-rocket_svg__cls-1{fill:#243038}.filedrop-rocket_svg__cls-2{fill:#c0c6cb}.filedrop-rocket_svg__cls-3{fill:#e5e7e9}.filedrop-rocket_svg__cls-4{fill:#d0d4d8}'
        }
      </style>
    </defs>
    <path className="filedrop-rocket_svg__cls-1" d="M152.21 138.46h-32v-93h32zm-30-2h28v-89h-28z" />
    <path
      className="filedrop-rocket_svg__cls-1"
      transform="rotate(-45 136.317 61.556)"
      d="M135.32 40.2h2v42.73h-2z"
    />
    <path
      className="filedrop-rocket_svg__cls-1"
      transform="rotate(-45 136.317 61.556)"
      d="M114.95 60.56h42.73v2h-42.73z"
    />
    <path
      className="filedrop-rocket_svg__cls-1"
      transform="rotate(-45 136.314 92.667)"
      d="M135.32 71.3h2v42.73h-2z"
    />
    <path
      className="filedrop-rocket_svg__cls-1"
      transform="rotate(-45 136.314 92.667)"
      d="M114.95 91.66h42.73v2h-42.73z"
    />
    <path
      className="filedrop-rocket_svg__cls-1"
      transform="rotate(-45 136.317 122.056)"
      d="M135.32 100.7h2v42.73h-2z"
    />
    <path
      className="filedrop-rocket_svg__cls-1"
      transform="rotate(-45 136.317 122.056)"
      d="M114.95 121.06h42.73v2h-42.73z"
    />
    <path
      className="filedrop-rocket_svg__cls-1"
      d="M121.21 76.56h30v2h-30zM121.21 106.56h30v2h-30zM87.39 50.56h33.82v2H87.39zM88.11 55.46h33.1v2h-33.1z"
    />
    <path
      className="filedrop-rocket_svg__cls-2"
      d="M45.36 97.31a27 27 0 0 0-26.3 20.87 5 5 0 0 0 4.88 6.13h42.84a5 5 0 0 0 4.88-6.13 27 27 0 0 0-26.3-20.87z"
    />
    <path
      className="filedrop-rocket_svg__cls-1"
      d="M66.78 125.31H23.94a6 6 0 0 1-5.85-7.31 28 28 0 0 1 54.55 0 6 6 0 0 1-5.86 7.36zm-21.42-27A25.87 25.87 0 0 0 20 118.4a4 4 0 0 0 3.91 4.91h42.87a4 4 0 0 0 3.14-1.52 4 4 0 0 0 .77-3.39 25.87 25.87 0 0 0-25.33-20.09z"
    />
    <path
      className="filedrop-rocket_svg__cls-2"
      d="M78.36 97.31a27 27 0 0 0-26.3 20.87 5 5 0 0 0 4.88 6.13h42.84a5 5 0 0 0 4.88-6.13 27 27 0 0 0-26.3-20.87z"
    />
    <path
      className="filedrop-rocket_svg__cls-1"
      d="M99.78 125.31H56.94a6 6 0 0 1-5.85-7.31 28 28 0 0 1 54.55 0 6 6 0 0 1-5.86 7.36zm-21.42-27A25.87 25.87 0 0 0 53 118.4a4 4 0 0 0 3.91 4.91h42.87a4 4 0 0 0 3.14-1.52 4 4 0 0 0 .77-3.39 25.87 25.87 0 0 0-25.33-20.09z"
    />
    <path
      className="filedrop-rocket_svg__cls-3"
      d="M84.37 124.31c3.32-12.17 5.29-27.18 5.29-43.43 0-40.55-12.22-73.42-27.29-73.42s-27.3 32.87-27.3 73.42c0 16.25 2 31.26 5.29 43.43z"
    />
    <path
      className="filedrop-rocket_svg__cls-1"
      d="M85.13 125.31H39.6l-.2-.74c-3.49-12.75-5.33-27.86-5.33-43.69 0-41.73 12.43-74.42 28.3-74.42s28.29 32.69 28.29 74.42c0 15.83-1.84 30.94-5.32 43.69zm-44-2h42.48a168.39 168.39 0 0 0 5-42.43C88.66 41 76.86 8.46 62.37 8.46S36.07 41 36.07 80.88a167.91 167.91 0 0 0 5.06 42.43z"
    />
    <path className="filedrop-rocket_svg__cls-4" d="M75.37 136.87H49.36l-4-12.56h34.01l-4 12.56z" />
    <path
      className="filedrop-rocket_svg__cls-1"
      d="M76.1 137.87H48.63L44 123.31h36.74zm-26-2h24.54L78 125.31H46.73z"
    />
    <circle className="filedrop-rocket_svg__cls-2" cx={62.37} cy={78.88} r={15.75} />
    <path
      className="filedrop-rocket_svg__cls-1"
      d="M62.37 95.63a16.75 16.75 0 1 1 16.75-16.75 16.76 16.76 0 0 1-16.75 16.75zm0-31.5a14.75 14.75 0 1 0 14.75 14.75 14.76 14.76 0 0 0-14.75-14.75z"
    />
    <circle cx={62.37} cy={78.88} r={11} fill="#9ad6f5" />
    <path
      className="filedrop-rocket_svg__cls-1"
      d="M62.37 90.88a12 12 0 1 1 12-12 12 12 0 0 1-12 12zm0-22a10 10 0 1 0 10 10 10 10 0 0 0-10-10zM40.09 37.44h44.55v2H40.09z"
    />
    <path
      className="filedrop-rocket_svg__cls-4"
      d="M171.21 147.46h-160l3.79-9.38a1 1 0 0 1 .93-.62h150.6a1 1 0 0 1 .93.62z"
    />
    <path
      className="filedrop-rocket_svg__cls-1"
      d="M172.69 148.46H9.73L14 137.71a2 2 0 0 1 1.86-1.25h150.67a2 2 0 0 1 1.86 1.25zm-160-2h157l-3.2-8H15.89z"
    />
    <path className="filedrop-rocket_svg__cls-3" d="M11.21 147.46h160v11h-160z" />
    <path
      className="filedrop-rocket_svg__cls-1"
      d="M172.21 159.46h-162v-13h162zm-160-2h158v-9h-158z"
    />
    <path
      className="filedrop-rocket_svg__cls-2"
      d="M15.21 177.46H3.79a1 1 0 0 1-.9-1.43l8.32-17.57h30z"
    />
    <path
      className="filedrop-rocket_svg__cls-1"
      d="M15.54 178.46H3.79A2 2 0 0 1 2 175.6l8.6-18.14h33.67zm-3.7-19l-8 17h11.04l23.27-17z"
    />
    <path
      className="filedrop-rocket_svg__cls-2"
      d="M166.79 177.46h11.42a1 1 0 0 0 .9-1.43l-8.32-17.57h-30z"
    />
    <path
      className="filedrop-rocket_svg__cls-1"
      d="M178.21 178.46h-11.75l-28.73-21h33.69L180 175.6a2 2 0 0 1-1.81 2.86zm-11.09-2h11.09l-8.05-17h-26.31z"
    />
    <path
      className="filedrop-rocket_svg__cls-2"
      d="M85.49 177.05a1 1 0 0 0 .8.41h10.92c.73 0 15.58-19 15.58-19h-41z"
    />
    <path
      className="filedrop-rocket_svg__cls-1"
      d="M97.21 178.46H86.29a2 2 0 0 1-1.6-.82l-14.88-20.18h45l-1.26 1.61c-15.12 19.39-15.74 19.39-16.34 19.39zm-10.92-2l-.8.59.8-.59zm0 0h10.6c1.47-1.4 8.71-10.46 13.85-17h-37z"
    />
  </svg>
)

export default RocketSVG
