# frozen_string_literal: true

#
# Copyright (C) 2014 - present Instructure, Inc.
#
# This file is part of Canvas.
#
# Canvas is free software: you can redistribute it and/or modify it under
# the terms of the GNU Affero General Public License as published by the Free
# Software Foundation, version 3 of the License.
#
# Canvas is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
# details.
#
# You should have received a copy of the GNU Affero General Public License along
# with this program. If not, see <http://www.gnu.org/licenses/>.

module ContentLicenses
  def self.included(base)
    base.extend ContentLicenses::ClassMethods
  end

  LICENSES = ActiveSupport::OrderedHash[
    'private',
    {
      :readable_license =>
        -> { I18n.t('#cc.private', 'Private (Copyrighted)') },
      :license_url => "http://en.wikipedia.org/wiki/Copyright"
    },
    'public_domain',
    {
      :readable_license =>
        -> { I18n.t('#cc.public_domain', 'Public Domain') },
      :license_url => "http://en.wikipedia.org/wiki/Public_domain"
    },
    'cc_by',
    {
      :readable_license =>
        -> { I18n.t('#cc.by', 'CC Attribution') },
      :license_url => "http://creativecommons.org/licenses/by/4.0"
    },
    'cc_by_sa',
    {
      :readable_license =>
        -> { I18n.t('#cc.by_sa', 'CC Attribution Share Alike') },
      :license_url => "http://creativecommons.org/licenses/by-sa/4.0"
    },
    'cc_by_nc',
    {
      :readable_license =>
        -> { I18n.t('#cc.by_nc', 'CC Attribution Non-Commercial') },
      :license_url => "http://creativecommons.org/licenses/by-nc/4.0"
    },
    'cc_by_nc_sa',
    {
      :readable_license =>
        -> { I18n.t('#cc.by_nc_sa', 'CC Attribution Non-Commercial Share Alike')},
      :license_url => "http://creativecommons.org/licenses/by-nc-sa/4.0"
    },
    'cc_by_nd',
    {
      :readable_license =>
        -> { I18n.t('#cc.by_nd', 'CC Attribution No Derivatives') },
      :license_url => "http://creativecommons.org/licenses/by-nd/4.0"
    },
    'cc_by_nc_nd',
    {
      :readable_license =>
        -> { I18n.t('#cc.by_nc_nd', 'CC Attribution Non-Commercial No Derivatives') },
      :license_url => "http://creativecommons.org/licenses/by-nc-nd/4.0/"
    }
  ].freeze

  module ClassMethods
    def licenses
      ContentLicenses::LICENSES
    end

    def public_license?(license)
      license != 'private'
    end
  end
end
