# frozen_string_literal: true

#
# Copyright (C) 2011 - present Instructure, Inc.
#
# This file is part of Canvas.
#
# Canvas is free software: you can redistribute it and/or modify it under
# the terms of the GNU Affero General Public License as published by the Free
# Software Foundation, version 3 of the License.
#
# Canvas is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
# details.
#
# You should have received a copy of the GNU Affero General Public License along
# with this program. If not, see <http://www.gnu.org/licenses/>.

require 'xsd/qname'

# {urn:RespondusAPI}NVPair
#   name - SOAP::SOAPString
#   value - SOAP::SOAPString
class NVPair
  attr_accessor :name
  attr_accessor :value

  def initialize(name = nil, value = nil)
    @name = name
    @value = value
  end
end

# {urn:RespondusAPI}NVPairList
#   item - [NVPair]
# This was generated by wsdl2ruby.rb as:
# class NVPairList < Array
# end
# Which is a bit nicer interface I guess, except soap4r's ruby-to-soap code
# doesn't actually know what to do with it, and barfs. So through trial and
# error, I ended up with this, which matches the wsdl a lot closer anyway. Yay.
class NVPairList
  attr_accessor :item

  def initialize
    @item = []
  end
end
