Caliper Event Message
=====================

Caliper live events are Canvas live events transformed into Caliper format. Caliper is a format based on JSON-LD that seeks to standardize analytical data. Each event consists of a JSON payload with a defined structure.

Caliper also has a concept of metric profiles. These are logical groupings of events that provide coverage of a certain set of actions. For example, the Assignable profile contains a number of events related to assignments.

We are currently using version 1.1 of the Caliper specification.

## Caliper Event Properties

Canvas Caliper message event envelope consists of the following structure: sensor, sendTime, dataVersion, data attributes.

### sensor

Canvas account domain name, e.g. `"sensor": "http://oxana.instructure.com/"`

### sendTime

The timestamp of when a specific event was sent to subscriber. sendTime is valid if in ISO 8601 format, e.g. yyyy-mm-ddThh ss.SSSZ where 'T' separates the date from the time, while 'Z' indicates that the time is set to UTC.

### dataVersion

Value conforms with Caliper 1.1, i.e. http://purl.imsglobal.org/ctx/caliper/v1p1

### data

Contains an ordered collection of one Caliper event. In Canvas implementation, we issue one message per event. IMS Caliper v1p1 allows you to combine multiple Events/Entities in one message data and/or Entity described objects. Per Caliper v1p1 the Sensor MAY micEvent and Entity described data in the same Envelope.

Under data Event collection:

* Each event has a @context attribute whose value is http://purl.imsglobal.org/ctx/caliper/v1p1
* Each event has an id attribute whose value is a Version 4 UUID expressed as a URN using the form urn:uuid:, per RFC 4122, e.g: `"id": "urn:uuid:19f57ead-f709-45e0-9869-25c68d933d45"`
* Each event has a valid actor, action, object, and eventTime attributes.
  * type is a string value corresponding to the Term defined for the Event in the external IMS Caliper JSON-LD context document.
  * action is formed as a result of a purposeful action undertaken by the actor at a particular moment in time and within a given learning context. It is a string set to the appropriate Caliper Term; only one action can be specified per event.
  * actor is the agent who initiated the event in the system of origin, typically a Person, but not always. It is a hash containing an id and type attribute, each valid strings. For example:"actor": { "id": "http://oxana.instructure.com/", "type": "SoftwareApplication" }** SoftwareApplication actor will appear when an Event is initiated by system of Event origin maybe as a result of user interaction with a specific asset, but without user specific actions, e.g. GradeEvent for assessment is generated by Canvas when a quiz is set to auto-grade setting.
  * eventTime is a valid ISO 8601 formatted server timestamp when an event happened in the system of origin; e.g. yyyy-mm-ddThh ss.SSSZ where 'T' separates the date from the time while 'Z' indicates that the time is set to UTC, e.g. "eventTime":"2018-09-24T21:43:50.000Z"

The following OPTIONAL properties are available for certain events, please see Event Payloads for more details.

### generated

Encapsulates an entity that was created as a result of the interaction. Expressed as an object. Available only in a few specific event types , see payloads for details.

### edApp

The software that constitutes the application context. Expressed as an object.

edApp.id is represented as a customer Canvas domain URL e.g : http://oxana.instructure.com/ or a default URL: www.canvaslms.com depending on the producer of the event and the application end user accessing Canvas from.

edApp.id = account hostname when an event is produced by end user action : submitting an assignment, browsing application. Hostname might vary based on the account settings, it could show up as a vanity account URL , events triggered thru mobile app follow the same logic and provide canvas account domain URL for all events produced by end user.

edApp.id = DEFAULT_URL = 'www.canvaslms.com' when an event is triggered by an automated job run by software application. Typically you will not see request, session and hostname details in those events.

### group

Representation of the Canvas context type where the action took place. Expressed as an object. There are only two types of context used in Basic Caliper implementation: CourseOffering (Canvas Course) and CourseSection (Canvas Section).

### membership

The relationship between the actor and the group in terms of roles assigned and current status. Expressed as an object. We do not include a membership for gradeChanged since the actor is SoftwareApplication.

### session

A web application user session. Expressed as an object.

### extensions

Not all Canvas assets properties are covered by the Caliper spec. We add extensions to many events and entities. See specific Message type for details around supported object extensions.


## Caliper Event Extensions

**Description:** contain request details for user and system triggered events, extensions are listed in the `data[0].extensions["com.instructure.canvas"]`

| Field | Description |
|-|-|
| **client_ip** | The client IP address of the request that triggered the event. Only present in user-generated events |
| **hostname** | The domain of the Canvas instance for the request. Only present in user-generated events |
| **job_id** | The identifier for the asynchronous job. Only present in system-generated events (events emitted in an asynchronous job, not an HTTP request) |
| **job_tag** | A string identifying the type of job being performed. Only present in system-generated events (events emitted in an asynchronous job, not an HTTP request) |
| **request_id** | The identifier for this request. Correlates to Canvas Data table requests.id. Only present in user-generated events |
| **request_url** | The URL to the requested resource. Only present in user-generated events |
| **user_agent** | The User-Agent sent by the browser making the request. Only present in user-generated events |
| **version** | Canvas implementation version of Caliper p1v1 events |


## Caliper Event Actor Extensions

**Description:** contains user account and profile details for user triggered events, extensions are listed in the in the `data[0].actor.extensions["com.instructure.canvas"]`

| Field | Description |
|-|-|
| **entity_id** | The ID of the Canvas user who triggered the event |
| **root_account_id** | The Canvas id of the root account associated with the context of the event |
| **root_account_lti_guid** | The Canvas lti_guid of the root account associated with the context of the event |
| **root_account_uuid** | The Canvas uuid of the root account associated with the context of the event |
| **user_login** | The login of the current user. Only present in user-generated events (events emitted directly from an HTTP request) |
| **user_sis_id** | The SIS id of the user. Only present in user-generated events (events emitted directly from an HTTP request) |
| **real_user_id** | The ID of the Canvas user, only populated when masquerade feature is used |

