Basic
==============

<h2 id="assignment_created">assignment_created</h2>

**Definition:** The event is emitted anytime a new assignment is created by an end user or API request.

**Trigger:** Triggered when a new assignment is created in a course.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:08:59.579Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:3f672715-6aa8-4293-b62a-3b3319ff5701",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000001",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana@example.com",
            "user_sis_id": "456-T45",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000001"
          }
        }
      },
      "action": "Created",
      "object": {
        "id": "urn:instructure:canvas:assignment:21070000000000371",
        "type": "AssignableDigitalResource",
        "name": "add_new_assignment_3",
        "description": "<p>test assignment</p>",
        "dateCreated": "2018-10-03T14:50:31.000Z",
        "extensions": {
          "com.instructure.canvas": {
            "lock_at": "2018-10-01T05:59:59.000Z",
            "entity_id": "21070000000000371"
          }
        },
        "dateToShow": "2018-09-24T06:00:00.000Z",
        "dateToSubmit": "2018-10-01T05:59:59.000Z",
        "maxScore": 100
      },
      "eventTime": "2019-11-01T19:11:11.323Z",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000000000565",
        "type": "CourseOffering",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000000000565"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000000000565:Instructor:21070000000000001",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000000001",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000000000565",
          "type": "CourseOffering"
        },
        "roles": [
          "Instructor"
        ]
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/courses/565/assignments",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |
| **data[0].object.extensions["com.instructure.canvas"].lock_at** | The lock date (assignment is locked after this date) |



<h2 id="assignment_override_created">assignment_override_created</h2>

**Definition:** The event is emitted anytime an assignment override is created by an end user or API request.

**Trigger:** Triggered when an assignment override is created.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:08:59.579Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:3f672715-6aa8-4293-b62a-3b3319ff5701",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000001",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana@example.com",
            "user_sis_id": "456-T45",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000001"
          }
        }
      },
      "action": "Created",
      "object": {
        "id": "urn:instructure:canvas:assignment_override:21070000000000371",
        "type": "Entity",
        "extensions": {
          "com.instructure.canvas": {
            "lock_at": "2018-10-01T05:59:59.000Z",
            "entity_id": "21070000000000371",
            "assignment_id": "1035",
            "all_day": false,
            "all_day_date": "2018-10-01T05:59:59.000Z",
            "type": "ADHOC",
            "workflow_state": "active"
          }
        },
        "dateToShow": "2018-09-24T06:00:00.000Z",
        "dateToSubmit": "2018-10-01T05:59:59.000Z"
      },
      "eventTime": "2019-11-01T19:11:11.323Z",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000000000565",
        "type": "CourseOffering",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000000000565"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000000000565:Instructor:21070000000000001",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000000001",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000000000565",
          "type": "CourseOffering"
        },
        "roles": [
          "Instructor"
        ]
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/courses/565/assignments",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |
| **data[0].object.extensions["com.instructure.canvas"].assignment_id** | The Canvas id of the assignment linked to the override. |
| **data[0].object.extensions["com.instructure.canvas"].all_day** | The overridden all_day flag, or nil if not overridden. |
| **data[0].object.extensions["com.instructure.canvas"].all_day_date** | The overridden all_day_date, or nil if not overridden. |
| **data[0].object.extensions["com.instructure.canvas"].lock_at** | The overridden lock_at timestamp, or nil if not overridden. |
| **data[0].object.extensions["com.instructure.canvas"].type** | Override type - `ADHOC` (list of Students), `CourseSection`, or `Group`. |
| **data[0].object.extensions["com.instructure.canvas"].course_section_id** | (if `type='CourseSection'`) Canvas section id that this override applies to. |
| **data[0].object.extensions["com.instructure.canvas"].group_id** | (if `type='Group'`) Canvas group id that this override applies to. |
| **data[0].object.extensions["com.instructure.canvas"].workflow_state** | Workflow state of the override. (active, deleted) |



<h2 id="assignment_override_updated">assignment_override_updated</h2>

**Definition:** The event is emitted anytime an assignment override is updated by an end user or API request. Only changes to the fields included in the body of the event payload will emit the `updated` event.

**Trigger:** Triggered when an assignment override has been modified.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:09:00.554Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:0a2a8c4d-0ebc-4200-ab6f-095b3b16852d",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000001",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana@example.com",
            "user_sis_id": "456-T45",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000001"
          }
        }
      },
      "action": "Modified",
      "object": {
        "id": "urn:instructure:canvas:assignment_override:21070000000000371",
        "type": "Entity",
        "extensions": {
          "com.instructure.canvas": {
            "lock_at": "2018-10-01T05:59:59.000Z",
            "entity_id": "21070000000000371",
            "assignment_id": "1035",
            "all_day": false,
            "all_day_date": "2018-10-01T05:59:59.000Z",
            "type": "ADHOC",
            "workflow_state": "active"
          }
        },
        "dateToShow": "2018-09-24T06:00:00.000Z",
        "dateToSubmit": "2018-10-01T05:59:59.000Z"
      },
      "eventTime": "2019-11-01T19:11:14.005Z",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000001279362",
        "type": "CourseOffering",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000001279362"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000001279362:Instructor:21070000000000001",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000000001",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000001279362",
          "type": "CourseOffering"
        },
        "roles": [
          "Instructor"
        ]
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/courses/1279362/assignments/2030605",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |
| **data[0].object.extensions["com.instructure.canvas"].assignment_id** | The Canvas id of the assignment linked to the override. |
| **data[0].object.extensions["com.instructure.canvas"].all_day** | The overridden all_day flag, or nil if not overridden. |
| **data[0].object.extensions["com.instructure.canvas"].all_day_date** | The overridden all_day_date, or nil if not overridden. |
| **data[0].object.extensions["com.instructure.canvas"].lock_at** | The overridden lock_at timestamp, or nil if not overridden. |
| **data[0].object.extensions["com.instructure.canvas"].type** | Override type - `ADHOC` (list of Students), `CourseSection`, or `Group`. |
| **data[0].object.extensions["com.instructure.canvas"].course_section_id** | (if `type='CourseSection'`) Canvas section id that this override applies to. |
| **data[0].object.extensions["com.instructure.canvas"].group_id** | (if `type='Group'`) Canvas group id that this override applies to. |
| **data[0].object.extensions["com.instructure.canvas"].workflow_state** | Workflow state of the override. (active, deleted) |



<h2 id="assignment_updated">assignment_updated</h2>

**Definition:** The event is emitted anytime an assignment is updated by an end user or API request. Only changes to the fields included in the body of the event payload will emit the `updated` event.

**Trigger:** Triggered when an assignment has been modified.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:09:00.554Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:0a2a8c4d-0ebc-4200-ab6f-095b3b16852d",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000001",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana@example.com",
            "user_sis_id": "456-T45",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000001"
          }
        }
      },
      "action": "Modified",
      "object": {
        "id": "urn:instructure:canvas:assignment:21070000002030605",
        "type": "AssignableDigitalResource",
        "name": "A New Assignment For Today",
        "description": "<h3>Assignment Description<h3/> This is your tasks, students:...",
        "dateModified": "2019-11-05T13:38:00.218Z",
        "extensions": {
          "com.instructure.canvas": {
            "lock_at": "2019-11-05T13:38:00.218Z",
            "workflow_state": "published",
            "entity_id": "21070000002030605"
          }
        },
        "dateToShow": "2019-11-05T13:38:00.218Z",
        "dateToSubmit": "2019-11-05T13:38:00.218Z",
        "maxScore": 100
      },
      "eventTime": "2019-11-01T19:11:14.005Z",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000001279362",
        "type": "CourseOffering",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000001279362"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000001279362:Instructor:21070000000000001",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000000001",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000001279362",
          "type": "CourseOffering"
        },
        "roles": [
          "Instructor"
        ]
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/courses/1279362/assignments/2030605",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |
| **data[0].object.extensions["com.instructure.canvas"].lock_at** | The lock date (assignment is locked after this date) |
| **data[0].object.extensions["com.instructure.canvas"].workflow_state** | 1. Workflow state of the assignment when used in the assignment context (deleted, duplicating, failed_to_import, failed_to_duplicate, failed_to_migrate, importing, published, unpublished) - 2. Workflow state of the enrollment when used in the enrollment context (active, completed, creation_pending, deleted, inactive, invited) |



<h2 id="attachment_created">attachment_created</h2>

**Definition:** The event is emitted anytime a new file is uploaded by an end user or API request.

**Trigger:** Triggered anytime a file is uploaded into a course or user file directory.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:09:00.877Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:fd1fb7f0-405b-4487-a47d-3d5c0161061d",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:210700001234567",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "210700001234567"
          }
        }
      },
      "action": "Created",
      "object": {
        "id": "urn:instructure:canvas:attachment:21070000000000632",
        "type": "Document",
        "name": "enrollments (1).csv",
        "dateCreated": "2018-10-09T20:44:45.000Z",
        "extensions": {
          "com.instructure.canvas": {
            "context_id": "21070000000002329",
            "context_type": "Course",
            "filename": "enrollments+%281%29.csv",
            "folder_id": "21070000000001359",
            "entity_id": "21070000000000632"
          }
        },
        "mediaType": "text/csv"
      },
      "eventTime": "2019-11-01T19:11:00.830Z",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000000002329",
        "type": "CourseOffering",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000000002329"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000000002329:user:210700001234567",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:210700001234567",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000000002329",
          "type": "CourseOffering"
        }
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/files/capture",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].context_id** | The Canvas id of the current context |
| **data[0].object.extensions["com.instructure.canvas"].context_type** | The type of context where the event happened |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |
| **data[0].object.extensions["com.instructure.canvas"].filename** | The file name of the attachment. NOTE: This field will be truncated to only include the first 8192 characters. |
| **data[0].object.extensions["com.instructure.canvas"].folder_id** | The id of the folder where the attachment was saved |



<h2 id="attachment_deleted">attachment_deleted</h2>

**Definition:** The event is emitted anytime a file is removed by an end user or API request.

**Trigger:** Triggered anytime a file is deleted from a course or user file directory.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:09:01.199Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:00ea719b-38ea-4beb-934c-758ffa2cf1ea",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000123456",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana@example.com",
            "user_sis_id": "456-T45",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000123456"
          }
        }
      },
      "action": "Deleted",
      "object": {
        "id": "urn:instructure:canvas:attachment:21070000000000606",
        "type": "Document",
        "name": "enrollments.csv",
        "dateModified": "2018-10-11T20:32:48.000Z",
        "extensions": {
          "com.instructure.canvas": {
            "context_id": "21070000000000565",
            "context_type": "Course",
            "filename": "enrollments.csv",
            "folder_id": "21070000000001344",
            "entity_id": "21070000000000606"
          }
        },
        "mediaType": "text/csv"
      },
      "eventTime": "2019-11-01T04:00:46.918Z",
      "referrer": "https://oxana.instructure.com/courses/565/files",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000000000565",
        "type": "CourseOffering",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000000000565"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000000000565:user:21070000000123456",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000123456",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000000000565",
          "type": "CourseOffering"
        }
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/files/606",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].context_id** | The Canvas id of the current context |
| **data[0].object.extensions["com.instructure.canvas"].context_type** | The type of context where the event happened |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |
| **data[0].object.extensions["com.instructure.canvas"].filename** | The file name of the attachment. NOTE: This field will be truncated to only include the first 8192 characters. |
| **data[0].object.extensions["com.instructure.canvas"].folder_id** | The id of the folder where the attachment was saved |



<h2 id="attachment_updated">attachment_updated</h2>

**Definition:** The event is emitted anytime a file is updated by an end user or API request. Only changes to the fields included in the body of the event payload will emit the `updated` event.

**Trigger:** Triggered anytime a file is updated in a course or user file directory.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:09:01.502Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:0d4f85b5-f541-4c14-a405-d6a01e578d32",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000123456",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana@example.com",
            "user_sis_id": "456-T45",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000123456"
          }
        }
      },
      "action": "Modified",
      "object": {
        "id": "urn:instructure:canvas:attachment:21070000000000606",
        "type": "Document",
        "name": "enrollments.csv",
        "dateModified": "2018-10-11T20:32:48.000Z",
        "extensions": {
          "com.instructure.canvas": {
            "context_id": "21070000000000565",
            "context_type": "Course",
            "filename": "enrollments.csv",
            "folder_id": "21070000000001344",
            "entity_id": "21070000000000606"
          }
        },
        "mediaType": "text/csv"
      },
      "eventTime": "2019-11-01T19:11:18.234Z",
      "referrer": "https://oxana.instructure.com/courses/565/files",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000000000565",
        "type": "CourseOffering",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000000000565"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000000000565:user:21070000000123456",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000123456",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000000000565",
          "type": "CourseOffering"
        }
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/files/606",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].context_id** | The Canvas id of the current context |
| **data[0].object.extensions["com.instructure.canvas"].context_type** | The type of context where the event happened |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |
| **data[0].object.extensions["com.instructure.canvas"].filename** | The file name of the attachment. NOTE: This field will be truncated to only include the first 8192 characters. |
| **data[0].object.extensions["com.instructure.canvas"].folder_id** | The id of the folder where the attachment was saved |



<h2 id="course_created">course_created</h2>

**Definition:** The event is emitted anytime a new course is created by an end user or API request.

**Trigger:** Triggered when a new course is created (or copied).



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:09:02.437Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:79d0955f-d697-4293-b361-6f420c8f254b",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000001",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana@example.com",
            "user_sis_id": "456-T45",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000001"
          }
        }
      },
      "action": "Created",
      "object": {
        "id": "urn:instructure:canvas:course:21070000000000056",
        "type": "CourseOffering",
        "name": "Linear Algebra",
        "extensions": {
          "com.instructure.canvas": {
            "entity_id": "21070000000000056"
          }
        }
      },
      "eventTime": "2019-11-05T13:38:00.218Z",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/accounts/438/courses",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |



<h2 id="course_updated">course_updated</h2>

**Definition:** The event is emitted anytime a course is updated by an end user or API request. Examples of updates include publishing a course, updating a course name, or changing a course's configuration.

**Trigger:** Triggered when a course is updated.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:09:02.437Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:79d0955f-d697-4293-b361-6f420c8f254b",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000001",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana@example.com",
            "user_sis_id": "456-T45",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000001"
          }
        }
      },
      "action": "Modified",
      "object": {
        "id": "urn:instructure:canvas:course:21070000000000056",
        "type": "CourseOffering",
        "name": "Linear Algebra",
        "extensions": {
          "com.instructure.canvas": {
            "entity_id": "21070000000000056",
            "workflow_state": "available"
          }
        }
      },
      "eventTime": "2019-11-05T13:38:00.218Z",
      "referrer": "https://oxana.instructure.com/courses/21070000000000056",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/accounts/438/courses",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |
| **data[0].object.extensions["com.instructure.canvas"].workflow_state** | The workflow state of the the course. Can be one of created or claimed (unpublished course), available (published course), completed, or deleted. |



<h2 id="enrollment_created">enrollment_created</h2>

**Definition:** The event is emitted anytime a new enrollment is added to a course by an end user or API request.

**Trigger:** Triggered when a new course enrollment is created.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:09:05.296Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:1145bf32-0ada-462d-9c97-7acd5b513472",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000001",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana@example.com",
            "user_sis_id": "456-T45",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000001"
          }
        }
      },
      "action": "Created",
      "object": {
        "id": "urn:instructure:canvas:enrollment:21070000000046825",
        "type": "Entity",
        "dateCreated": "2018-10-09T21:07:33.000Z",
        "extensions": {
          "com.instructure.canvas": {
            "course_id": "urn:instructure:canvas:course:21070000000000565",
            "course_section_id": "urn:instructure:canvas:course:21070000000000565:section:21070000000004811",
            "limit_privileges_to_course_section": false,
            "type": "StudentEnrollment",
            "user_id": "urn:instructure:canvas:user:21070000000020064",
            "user_name": "Isaac Newton",
            "workflow_state": "invited",
            "entity_id": "21070000000046825"
          }
        }
      },
      "eventTime": "2018-10-09T21:07:33.000Z",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000000000565:section:21070000000004811",
        "type": "CourseSection",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000000000565"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000000000565:section:21070000000004811:user:21070000000000001",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000000001",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000000000565:section:21070000000004811",
          "type": "CourseSection",
          "subOrganizationOf": {
            "id": "urn:instructure:canvas:course:21070000000000565",
            "type": "CourseOffering"
          }
        }
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/sections/4811/enrollments?enrollment[user_id]=20064&amp;enrollment[type]=StudentEnrollment&amp;enrollment[enrollment_state]=invited&amp;enrollment[limit_privileges_to_course_section]=true&amp;enrollment[notify]=true",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].course_id** | The Canvas id of the course for this enrollment |
| **data[0].object.extensions["com.instructure.canvas"].course_section_id** | The id of the section of the course for the new enrollment |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |
| **data[0].object.extensions["com.instructure.canvas"].limit_privileges_to_course_section** | Whether students can only talk to students within their course section |
| **data[0].object.extensions["com.instructure.canvas"].type** | The type of enrollment; e.g. StudentEnrollment, TeacherEnrollment, ObserverEnrollment, etc. |
| **data[0].object.extensions["com.instructure.canvas"].user_id** | The Canvas id of the currently logged in user |
| **data[0].object.extensions["com.instructure.canvas"].user_name** | The user first and last name |
| **data[0].object.extensions["com.instructure.canvas"].workflow_state** | 1. Workflow state of the assignment when used in the assignment context (deleted, duplicating, failed_to_import, failed_to_duplicate, failed_to_migrate, importing, published, unpublished) - 2. Workflow state of the enrollment when used in the enrollment context (active, completed, creation_pending, deleted, inactive, invited) |



<h2 id="enrollment_state_created">enrollment_state_created</h2>

**Definition:** The event is emitted anytime a new enrollment record is added to a course.

**Trigger:** Triggered when a new course enrollment is created with a new workflow_state.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:09:05.617Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:0b3800ce-e9c5-4566-8b5f-72ea469a07b7",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000001",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana@example.com",
            "user_sis_id": "456-T45",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000001"
          }
        }
      },
      "action": "Created",
      "object": {
        "id": "urn:instructure:canvas:enrollment:21070000000000143",
        "type": "Entity",
        "extensions": {
          "com.instructure.canvas": {
            "access_is_current": true,
            "restricted_access": false,
            "state": "pending_invited",
            "state_is_current": true,
            "state_valid_until": "2019-11-05T13:38:00.218Z",
            "entity_id": "21070000000000143"
          }
        },
        "startedAtTime": "2019-10-05T13:38:00.000Z"
      },
      "eventTime": "2019-11-01T19:11:09.910Z",
      "referrer": "https://oxana.instructure.com/accounts/1?enrollment_term_id=83&search_term=hsw",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000000000565",
        "type": "CourseOffering",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000000000565"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000000000565:user:21070000000000001",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000000001",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000000000565",
          "type": "CourseOffering"
        }
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/courses/565/enroll_users",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].access_is_current** | Indicates if the enrollment_state is up to date |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |
| **data[0].object.extensions["com.instructure.canvas"].restricted_access** | Indicates whether enrollment access is restricted, set to 'TRUE' if enrollment state is restricted |
| **data[0].object.extensions["com.instructure.canvas"].state_is_current** | Indicates if this enrollment_state is up to date |
| **data[0].object.extensions["com.instructure.canvas"].state** | The state of the enrollment |
| **data[0].object.extensions["com.instructure.canvas"].state_valid_until** | The time at which this enrollment is no longer valid |



<h2 id="enrollment_state_updated">enrollment_state_updated</h2>

**Definition:** The event is emitted anytime an enrollment record workflow state changes.

**Trigger:** Triggered when a course enrollment workflow_state changes.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-21T23:47:22.555Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:89c8b4b1-1caf-4af1-a391-c4d6da12eb09",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000012",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "applications.admin",
            "user_sis_id": "applications.admin",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000012"
          }
        }
      },
      "action": "Modified",
      "object": {
        "id": "urn:instructure:canvas:enrollment:21070000000001999",
        "type": "Entity",
        "extensions": {
          "com.instructure.canvas": {
            "access_is_current": true,
            "restricted_access": false,
            "state": "deleted",
            "state_is_current": true,
            "entity_id": "21070000000001999"
          }
        }
      },
      "eventTime": "2019-11-01T19:11:18.125Z",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000000000565",
        "type": "CourseOffering",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000000000565"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000000000565:user:21070000000000012",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000000012",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000000000565",
          "type": "CourseOffering"
        }
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Somebot/12.0",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instrucvture.com/api/v1/courses/565/enrollments/1999?task=delete&access_token=1~fHJKsdaHK423KGHFJDAS32hkgfdaks342423jfKJKj33hjlklkgjkl2jkljlk34j",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].access_is_current** | Indicates if the enrollment_state is up to date |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |
| **data[0].object.extensions["com.instructure.canvas"].restricted_access** | Indicates whether enrollment access is restricted, set to 'TRUE' if enrollment state is restricted |
| **data[0].object.extensions["com.instructure.canvas"].state_is_current** | Indicates if this enrollment_state is up to date |
| **data[0].object.extensions["com.instructure.canvas"].state** | The state of the enrollment |
| **data[0].object.extensions["com.instructure.canvas"].state_valid_until** | The time at which this enrollment is no longer valid |



<h2 id="enrollment_updated">enrollment_updated</h2>

**Definition:** The event is emitted anytime an enrollment record is updated by an end user or API request. Only changes to the fields included in the body of the event payload will emit the `updated` event.

**Trigger:** Triggered when a course enrollment is modified.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-21T23:47:22.832Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:7205050c-95ed-4c5f-9ecf-2998c7d3a02c",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000987",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana",
            "user_sis_id": "ABC123",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000987"
          }
        }
      },
      "action": "Modified",
      "object": {
        "id": "urn:instructure:canvas:enrollment:21070000000549222",
        "type": "Entity",
        "dateCreated": "2019-10-11T13:16:23.000Z",
        "dateModified": "2019-11-01T19:11:18.000Z",
        "extensions": {
          "com.instructure.canvas": {
            "course_id": "urn:instructure:canvas:course:21070000000000565",
            "course_section_id": "urn:instructure:canvas:course:21070000000000565:section:21070000000509348",
            "limit_privileges_to_course_section": false,
            "type": "StudentEnrollment",
            "user_id": "urn:instructure:canvas:user:21070000000093482",
            "user_name": "Isaac Newton",
            "workflow_state": "invited",
            "entity_id": "21070000000549222"
          }
        }
      },
      "eventTime": "2019-11-01T19:11:19.407Z",
      "referrer": "https://oxana.instructure.com/courses/565/users",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000000000565:section:21070000000509348",
        "type": "CourseSection",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000000000565"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000000000565:section:21070000000509348:Instructor:21070000000000987",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000000987",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000000000565:section:21070000000509348",
          "type": "CourseSection",
          "subOrganizationOf": {
            "id": "urn:instructure:canvas:course:21070000000000565",
            "type": "CourseOffering"
          }
        },
        "roles": [
          "Instructor"
        ]
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/courses/565/enroll_users",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].course_id** | The Canvas id of the course for this enrollment |
| **data[0].object.extensions["com.instructure.canvas"].course_section_id** | The id of the section of the course for the new enrollment |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |
| **data[0].object.extensions["com.instructure.canvas"].limit_privileges_to_course_section** | Whether students can only talk to students within their course section |
| **data[0].object.extensions["com.instructure.canvas"].type** | The type of enrollment; e.g. StudentEnrollment, TeacherEnrollment, ObserverEnrollment, etc. |
| **data[0].object.extensions["com.instructure.canvas"].user_id** | The Canvas id of the currently logged in user |
| **data[0].object.extensions["com.instructure.canvas"].user_name** | The user first and last name |
| **data[0].object.extensions["com.instructure.canvas"].workflow_state** | 1. Workflow state of the assignment when used in the assignment context (deleted, duplicating, failed_to_import, failed_to_duplicate, failed_to_migrate, importing, published, unpublished) - 2. Workflow state of the enrollment when used in the enrollment context (active, completed, creation_pending, deleted, inactive, invited) |



<h2 id="group_category_created">group_category_created</h2>

**Definition:** The event is emitted anytime a new group category is added to a course group by an end user or API request.

**Trigger:** Triggered when a new group category is created.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:09:07.206Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:709bdb27-b1e4-4d48-a207-38d71250264f",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000001",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana@example.com",
            "user_sis_id": "456-T45",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000001"
          }
        }
      },
      "action": "Created",
      "object": {
        "id": "urn:instructure:canvas:groupCategory:21070000000000049",
        "type": "Entity",
        "name": "Live_events_Group1",
        "extensions": {
          "com.instructure.canvas": {
            "entity_id": "21070000000000049"
          }
        }
      },
      "eventTime": "2019-11-01T15:06:48.462Z",
      "referrer": "https://oxana.instructure.com/courses/565/assignments/7655/edit",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:565",
        "type": "CourseOffering",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "565"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:565:Instructor:21070000000000001",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000000001",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:565",
          "type": "CourseOffering"
        },
        "roles": [
          "Instructor"
        ]
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/courses/565/group_categories",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |



<h2 id="group_created">group_created</h2>

**Definition:** The event is emitted anytime a new group is added to a course by an end user or API request.

**Trigger:** Triggered when a new group is created.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:09:07.890Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:6405114f-2664-4f87-b5d5-67c1f4e4c030",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000001",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana@example.com",
            "user_sis_id": "456-T45",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000001"
          }
        }
      },
      "action": "Created",
      "object": {
        "id": "urn:instructure:canvas:group:21070000000000051",
        "type": "Group",
        "name": "Group 1",
        "extensions": {
          "com.instructure.canvas": {
            "entity_id": "21070000000000051"
          }
        },
        "isPartOf": {
          "id": "urn:instructure:canvas:groupCategory:21070000000001149",
          "type": "Entity",
          "name": "Live_events_Group1"
        }
      },
      "eventTime": "2019-11-01T00:08:52.795Z",
      "referrer": "https://oxana.instructure.com/courses/565/groups",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000000000565",
        "type": "CourseOffering",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000000000565"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000000000565:user:21070000000000001",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000000001",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000000000565",
          "type": "CourseOffering"
        }
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/group_categories/1149/groups",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |



<h2 id="group_membership_created">group_membership_created</h2>

**Definition:** The event is emitted anytime a new member is added to a course group by an end user or API request.

**Trigger:** Triggered when a new user is added to a group.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:09:08.260Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:ee8e1bb5-baf2-44db-873c-5ca52d8bf5a5",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000001",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana@example.com",
            "user_sis_id": "456-T45",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000001"
          }
        }
      },
      "action": "Created",
      "object": {
        "id": "urn:instructure:canvas:groupMembership:21070000000123460",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000000047",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:group:21070000000000051",
          "type": "Group",
          "name": "Group 1",
          "extensions": {
            "com.instructure.canvas": {
              "entity_id": "21070000000123460"
            }
          },
          "isPartOf": {
            "id": "urn:instructure:canvas:groupCategory:21070000000049012",
            "type": "Entity",
            "name": "Live_events_Group1"
          }
        }
      },
      "eventTime": "2019-11-01T19:11:21.467Z",
      "referrer": "https://oxana.instructure.com/courses/135519/groups",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/group_categories/30575/clone_with_name",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |



<h2 id="submission_created">submission_created</h2>

**Definition:** The event is emitted anytime an end user or API request submits an assignment.

**Trigger:** Triggered when a submission gets updated and has not yet been submitted.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:09:14.293Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:bd9dedcf-6fd9-4605-82d6-325c4e2adaf6",
      "type": "AssignableEvent",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000014012",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000014012"
          }
        }
      },
      "action": "Submitted",
      "object": {
        "id": "urn:instructure:canvas:submission:21070000012345567",
        "type": "Attempt",
        "dateCreated": "2019-11-01T19:11:21.419Z",
        "extensions": {
          "com.instructure.canvas": {
            "submission_type": "online_text_entry",
            "url": "https://test.submission.net",
            "entity_id": "21070000012345567"
          }
        },
        "assignee": {
          "id": "urn:instructure:canvas:user:21070000000014012",
          "type": "Person"
        },
        "assignable": {
          "id": "urn:instructure:canvas:assignment:21070000001234012",
          "type": "AssignableDigitalResource"
        },
        "count": 12,
        "body": "Test Submission Data"
      },
      "eventTime": "2019-11-01T19:11:21.419Z",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/lti/v1/tools/453919/grade_passback",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |
| **data[0].object.extensions["com.instructure.canvas"].submission_type** | The types of submission (basic_lti_launch, discussion_topic, media_recording, online_quiz, online_text_entry, online_upload, online_url) |
| **data[0].object.extensions["com.instructure.canvas"].url** | The URL of the request that triggered the event. Only present in user-generated events |



<h2 id="submission_updated">submission_updated</h2>

**Definition:** The event is emitted anytime an end user or API request re-submits an assignment.

**Trigger:** Triggered when a submission gets updated and has previously been submitted.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-21T22:25:55.856Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:77516df0-a8bb-49ae-a859-0471e9269378",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000054321",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana",
            "user_sis_id": "a10000",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "3298d98d938298kjasdgfklsdfj48348gJGJDASG",
            "root_account_uuid": "398DFJSAFJDfgkhdsahk439849GJSDKGJSAFKG99",
            "entity_id": "21070000000054321"
          }
        }
      },
      "action": "Modified",
      "object": {
        "id": "urn:instructure:canvas:submission:21070000002947931",
        "type": "Attempt",
        "dateModified": "2019-11-06T16:46:46.000Z",
        "extensions": {
          "com.instructure.canvas": {
            "submission_type": "online_upload",
            "entity_id": "21070000002947931"
          }
        },
        "assignee": {
          "id": "urn:instructure:canvas:user:21070000000098765",
          "type": "Person"
        },
        "assignable": {
          "id": "urn:instructure:canvas:assignment:21070000000012345",
          "type": "AssignableDigitalResource"
        },
        "count": 1
      },
      "eventTime": "2019-11-06T16:46:46.446Z",
      "referrer": "https://oxana.instructure.com/courses/565/gradebook",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000000000565",
        "type": "CourseOffering",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000000000565"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000000000565:Instructor:21070000000054321",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000054321",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000000000565",
          "type": "CourseOffering"
        },
        "roles": [
          "Instructor"
        ]
      },
      "session": {
        "id": "urn:instructure:canvas:session:b5e43107370d071208e098b098a09845",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "129b89de-293c-4201-3201-09a90b039e09",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/courses/565/assignments/12345/submissions/98765",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |
| **data[0].object.extensions["com.instructure.canvas"].submission_type** | The types of submission (basic_lti_launch, discussion_topic, media_recording, online_quiz, online_text_entry, online_upload, online_url) |



<h2 id="syllabus_updated">syllabus_updated</h2>

**Definition:** The event is emitted anytime a syllabus is changed in a course by an end user or API request. Only changes to the fields included in the body of the event payload will emit the `updated` event.

**Trigger:** Triggered when a course syllabus gets updated.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:09:14.936Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:fcca5cae-cff1-41b3-b944-79013e30cbec",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000001",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana@example.com",
            "user_sis_id": "456-T45",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000001"
          }
        }
      },
      "action": "Modified",
      "object": {
        "id": "urn:instructure:canvas:course:21070000000000565",
        "type": "Document",
        "name": "Syllabus",
        "creators": [
          {
            "id": "urn:instructure:canvas:user:21070000000000001",
            "type": "Person"
          }
        ],
        "body": "<p><iframe style=\"width: 800px; height: 880px;\" src=\"/courses/565/external_tools/retrieve?display=borderless&amp;url=https%3A%2F%2Foxana.instructuremedia.com%2F..."
      },
      "eventTime": "2019-11-01T19:11:14.519Z",
      "referrer": "https://oxana.instructure.com/courses/565/assignments/syllabus",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000000000565:user:21070000000000001",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000000001",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000000000565",
          "type": "CourseOffering"
        }
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/courses/565",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```





<h2 id="user_account_association_created">user_account_association_created</h2>

**Definition:** The event is emitted anytime a user is created in an account.

**Trigger:** Triggered when a user is added to an account.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-21T23:47:23.110Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:97224c19-0b41-4d49-b6f6-1c4762ac9ed4",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000987",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana",
            "user_sis_id": "OXANA123",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000987"
          }
        }
      },
      "action": "Created",
      "object": {
        "id": "urn:instructure:canvas:account:21070000000000001",
        "type": "Entity",
        "dateCreated": "2019-11-01T19:11:00.000Z",
        "dateModified": "2019-11-01T19:11:00.000Z",
        "extensions": {
          "com.instructure.canvas": {
            "is_admin": false,
            "user_id": "urn:instructure:canvas:user:21070000000042342"
          }
        }
      },
      "eventTime": "2019-11-01T19:11:00.890Z",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Somebot/1.0",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/accounts/566/users",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].object.extensions["com.instructure.canvas"].is_admin** | Indicates whether a user has an administrator role |
| **data[0].object.extensions["com.instructure.canvas"].user_id** | The Canvas id of the currently logged in user |



<h2 id="wiki_page_created">wiki_page_created</h2>

**Definition:** The event is emitted anytime a new wiki page is created by an end user or API request.

**Trigger:** Triggered when a new wiki page is created.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-21T23:47:23.376Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:c6fd66af-c89a-4554-bb03-aa35b3e75525",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000333",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana",
            "user_sis_id": "OXANA123",
            "root_account_id": "21070000000000333",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000333"
          }
        }
      },
      "action": "Created",
      "object": {
        "id": "urn:instructure:canvas:wikiPage:21070000000048392",
        "type": "Page",
        "name": "Great new wiki page",
        "extensions": {
          "com.instructure.canvas": {
            "body": "This is the text of a simply awesome new wiki page!",
            "entity_id": "21070000000048392"
          }
        }
      },
      "eventTime": "2019-11-01T19:11:12.455Z",
      "referrer": "https://oxana.instructure.com/courses/565/modules",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000000000565",
        "type": "CourseOffering",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000000000565"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000000000565:Instructor:21070000000000333",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000000333",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000000000565",
          "type": "CourseOffering"
        },
        "roles": [
          "Instructor"
        ]
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/courses/565/modules/items/982711/duplicate",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].body** | The body of the new page. NOTE: This field will be truncated to only include the first 8192 characters. |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |



<h2 id="wiki_page_deleted">wiki_page_deleted</h2>

**Definition:** The event is emitted anytime a wiki page is deleted by an end user or API request.

**Trigger:** Triggered when a wiki page is deleted.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-16T02:09:16.608Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:646628ff-d21b-4fb9-a672-56d94a8a7b73",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000000001",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana@example.com",
            "user_sis_id": "456-T45",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000000001"
          }
        }
      },
      "action": "Deleted",
      "object": {
        "id": "urn:instructure:canvas:wikiPage:21070000000000009",
        "type": "Page",
        "name": "Page 1 Updated",
        "extensions": {
          "com.instructure.canvas": {
            "entity_id": "21070000000000009"
          }
        }
      },
      "eventTime": "2019-11-01T19:11:13.729Z",
      "referrer": "https://oxana.instructure.com/courses/1013182/pages/ccs-online-logo-instructions?module_item_id=9653761",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000000000565",
        "type": "CourseOffering",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000000000565"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000000000565:Instructor:21070000000000001",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000000001",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000000000565",
          "type": "CourseOffering"
        },
        "roles": [
          "Instructor"
        ]
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/courses/1499839/pages/ccs-online-logo-instructions",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].body** | The body of the new page. NOTE: This field will be truncated to only include the first 8192 characters. |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |



<h2 id="wiki_page_updated">wiki_page_updated</h2>

**Definition:** The event is emitted anytime a wiki page is altered by an end user or API request.

**Trigger:** Triggered when title or body of wiki page is altered.



### Payload Example:

```json
{
  "sensor": "http://oxana.instructure.com/",
  "sendTime": "2019-11-21T23:47:23.652Z",
  "dataVersion": "http://purl.imsglobal.org/ctx/caliper/v1p1",
  "data": [
    {
      "@context": "http://purl.imsglobal.org/ctx/caliper/v1p1",
      "id": "urn:uuid:3e59b9f1-426f-4b84-b18d-e984647a38d0",
      "type": "Event",
      "actor": {
        "id": "urn:instructure:canvas:user:21070000000009876",
        "type": "Person",
        "extensions": {
          "com.instructure.canvas": {
            "user_login": "oxana",
            "root_account_id": "21070000000000001",
            "root_account_lti_guid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs.oxana.instructure.com",
            "root_account_uuid": "VicYj3cu5BIFpoZhDVU4DZumnlBrWi1grgJEzADs",
            "entity_id": "21070000000009876"
          }
        }
      },
      "action": "Modified",
      "object": {
        "id": "urn:instructure:canvas:wikiPage:72270000000674553",
        "type": "Page",
        "name": "A great wiki page",
        "extensions": {
          "com.instructure.canvas": {
            "body": "This is wiki page text",
            "entity_id": "72270000000674553"
          }
        }
      },
      "eventTime": "2019-11-01T19:11:17.869Z",
      "referrer": "https://oxana.instructure.com/courses/565/pages/collaborative-project-team-sign-up/edit",
      "edApp": {
        "id": "http://oxana.instructure.com/",
        "type": "SoftwareApplication"
      },
      "group": {
        "id": "urn:instructure:canvas:course:21070000000000565",
        "type": "CourseOffering",
        "extensions": {
          "com.instructure.canvas": {
            "context_type": "Course",
            "entity_id": "21070000000000565"
          }
        }
      },
      "membership": {
        "id": "urn:instructure:canvas:course:21070000000000565:Learner:21070000000009876",
        "type": "Membership",
        "member": {
          "id": "urn:instructure:canvas:user:21070000000009876",
          "type": "Person"
        },
        "organization": {
          "id": "urn:instructure:canvas:course:21070000000000565",
          "type": "CourseOffering"
        },
        "roles": [
          "Learner"
        ]
      },
      "session": {
        "id": "urn:instructure:canvas:session:ef686f8ed684abf78cbfa1f6a58112b5",
        "type": "Session"
      },
      "extensions": {
        "com.instructure.canvas": {
          "hostname": "oxana.instructure.com",
          "request_id": "1dd9dc6f-2fb0-4c19-a6c5-7ee1bf3ed295",
          "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36",
          "client_ip": "93.184.216.34",
          "request_url": "https://oxana.instructure.com/api/v1/courses/565/pages/collaborative-project-team-sign-up",
          "version": "1.0.0"
        }
      }
    }
  ]
}
```




### Event Body Schema

| Field | Description |
|-|-|
| **data[0].group.extensions["com.instructure.canvas"].context_type** | Canvas context type where the action took place e.g context_type = Course. |
| **data[0].group.extensions["com.instructure.canvas"].entity_id** | Canvas context ID |
| **data[0].object.extensions["com.instructure.canvas"].body** | The body of the new page. NOTE: This field will be truncated to only include the first 8192 characters. |
| **data[0].object.extensions["com.instructure.canvas"].entity_id** | Canvas global ID of the object affected by the event |



