/*
 * Copyright (C) 2015 - present Instructure, Inc.
 *
 * This file is part of Canvas.
 *
 * Canvas is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License as published by the Free
 * Software Foundation, version 3 of the License.
 *
 * Canvas is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 */

import React from 'react'
import {InlineSVG} from '@instructure/ui-svg-images'

export default function EmptyDesert() {
  return (
    <InlineSVG
      viewBox="0 0 400 250"
      xmlns="http://www.w3.org/2000/svg"
      height="15.625rem"
      width="25rem"
    >
      <circle cx="300.4" cy="38.8" r="13.6" fill="#fdd089" />
      <path
        fill="#fbb03b"
        d="M300.4 53.4c-8.1 0-14.6-6.6-14.6-14.6s6.6-14.6 14.6-14.6S315 30.7 315 38.8s-6.6 14.6-14.6 14.6zm0-27.3c-7 0-12.6 5.7-12.6 12.6s5.7 12.6 12.6 12.6c7 0 12.6-5.7 12.6-12.6s-5.7-12.6-12.6-12.6z"
      />
      <path
        fill="#fbb03b"
        d="M300.4 62.5c-.6 0-1-.4-1-1v-9.1c0-.6.4-1 1-1s1 .4 1 1v9.1c0 .6-.5 1-1 1zM300.4 26.1c-.6 0-1-.4-1-1V16c0-.6.4-1 1-1s1 .4 1 1v9.1c0 .6-.5 1-1 1zM313.4 58.4c-.3 0-.6-.1-.8-.4l-5.2-7.5c-.3-.5-.2-1.1.2-1.4.5-.3 1.1-.2 1.4.2l5.2 7.5c.3.5.2 1.1-.2 1.4-.2.2-.4.2-.6.2zM292.5 28.6c-.3 0-.6-.1-.8-.4l-5.2-7.5c-.3-.5-.2-1.1.2-1.4.5-.3 1.1-.2 1.4.2l5.2 7.5c.3.5.2 1.1-.2 1.4-.2.1-.4.2-.6.2zM321.8 47.5c-.1 0-.2 0-.3-.1l-8.6-3.1c-.5-.2-.8-.8-.6-1.3.2-.5.8-.8 1.3-.6l8.6 3.1c.5.2.8.8.6 1.3-.2.5-.6.7-1 .7zM287.6 35.1c-.1 0-.2 0-.3-.1l-8.6-3.1c-.5-.2-.8-.8-.6-1.3.2-.5.8-.8 1.3-.6l8.6 3.1c.5.2.8.8.6 1.3-.3.4-.6.7-1 .7zM313.5 36.2c-.4 0-.8-.3-1-.7-.1-.5.2-1.1.7-1.2l8.8-2.4c.5-.1 1.1.2 1.2.7.1.5-.2 1.1-.7 1.2l-8.8 2.4h-.2zM278.4 45.7c-.4 0-.8-.3-1-.7-.1-.5.2-1.1.7-1.2l8.8-2.4c.5-.1 1.1.2 1.2.7.1.5-.2 1.1-.7 1.2l-8.8 2.4c-.1-.1-.1 0-.2 0zM309.1 29.3c-.2 0-.5-.1-.6-.2-.4-.4-.5-1-.1-1.4l5.9-7c.4-.4 1-.5 1.4-.1.4.4.5 1 .1 1.4l-5.9 7c-.2.2-.5.3-.8.3zM285.7 57.2c-.2 0-.5-.1-.6-.2-.4-.4-.5-1-.1-1.4l5.9-7c.4-.4 1-.5 1.4-.1.4.4.5 1 .1 1.4l-5.9 7c-.2.2-.5.3-.8.3z"
      />
      <path
        fill="#d4a082"
        d="M369.2 171.8l-9.9-6.1-9.2-3.7c-.2-.1-.3-.2-.4-.3l-3.6-3.6c-.2-.2-.4-.3-.6-.3l-3.1-.6c-.6-.1-1-.6-1-1.2v-35.3c0-.2-.1-.5-.2-.7l-2.1-3.2c-.2-.3-.6-.5-1-.5h-15.7c-1.1 0-2 .9-2 2v8c0 .7-.4 1.4-1 1.8-1.3.7-3-.2-3-1.8v-5.1c0-.3-.1-.6-.2-.9l-1.5-2.9c-.3-.7-1-1.1-1.8-1.1h-26.6c-.5 0-1 .2-1.3.5l-2.8 2.5c-.4.4-.7.9-.7 1.5v25.6c0 .7-.3 1.5-.9 1.9l-3.1 2.4-4.5 9-8.1 5-4.5.7c-.8.1-1.5.7-1.8 1.4l-2.2 4.9h112.8zM189.2 171.8l-4.4-8.4-14.3-4.2c-.4-.1-.7-.3-.9-.6l-8.2-10.4c-.2-.2-.4-.4-.7-.5l-11.6-5.4-4.7-2.9c-1.1-.7-1.8-1.9-1.8-3.2v-33.5c0-.4-.1-.7-.2-1.1l-1.4-4.8c-.5-1.6-1.9-2.7-3.6-2.7h-5.3c-1.4 0-2.7.8-3.4 2.1l-1.8 3.5c-.3.5-.4 1.1-.4 1.7v47.3h-4.3c-.8 0-1.5-.5-1.8-1.2l-4.6-11.7c-.6-1.4-2-2.4-3.5-2.4h-5.2c-1 0-1.9-.8-1.9-1.9v-37c0-.7-.2-1.4-.5-1.9l-5.6-9.3c-.7-1.1-1.9-1.8-3.2-1.8H51.4c-1 0-2 .4-2.7 1.1L45 86.3c-.7.7-1.1 1.7-1.1 2.7v67.2c0 .7-.4 1.3-1 1.7l-25.5 13.9h171.8z"
      />
      <path fill="#243038" d="M8.4 170.8h382v2H8.4z" />
      <path
        fill="#243038"
        d="M373.2 172.8H254.8l2.8-6.3c.5-1.1 1.4-1.8 2.6-2l4.3-.7 7.6-4.8 4.4-8.9 3.3-2.5c.3-.3.5-.7.5-1.1v-25.6c0-.9.4-1.7 1-2.2l2.8-2.5c.6-.5 1.3-.8 2-.8h26.6c1.1 0 2.2.6 2.7 1.7l1.5 2.9c.2.4.3.9.3 1.3v5.1c0 .5.3.8.5.9.1.1.5.3 1 0 .3-.2.5-.5.5-.9v-8c0-1.7 1.4-3 3-3H338c.7 0 1.4.4 1.8 1l2.1 3.2c.2.4.4.8.4 1.2V156c0 .1.1.2.2.2l3.1.6c.4.1.8.3 1.1.6l3.6 3.6 9.2 3.7 13.7 8.1zm-115.3-2h103.2l-2.2-4.1-9.2-3.7c-.3-.1-.5-.3-.7-.5l-3.6-3.6s-.1 0-.1-.1l-3.1-.6c-1-.2-1.8-1.1-1.8-2.2v-35.3-.1l-2.1-3.2c0-.1-.1-.1-.2-.1h-15.7c-.6 0-1 .5-1 1v8c0 1.1-.6 2.1-1.5 2.6h-.1c-.9.5-2.1.5-3 0-.9-.5-1.5-1.5-1.5-2.6v-5.1c0-.2 0-.3-.1-.5l-1.5-2.9c-.2-.3-.5-.6-.9-.6h-26.6c-.2 0-.5.1-.7.3l-2.8 2.5c-.2.2-.3.5-.3.8v25.6c0 1-.5 2.1-1.3 2.7l-2.9 2.3-4.5 9-8.5 5.3-4.7.8c-.5.1-.9.4-1.1.8l-1.5 3.5z"
      />
      <g>
        <path
          fill="#abc885"
          d="M342.5 129.5c3.4 0 6.1 2.7 6.1 6.1v11c0 3.4 4.4 6.8 9 8.6V98.3c0-3.4 2.7-6.1 6.1-6.1 3.4 0 6.1 2.7 6.1 6.1V142c4.6-1.8 9-5.2 9-8.6v-17.6c0-3.4 2.7-6.1 6.1-6.1 3.4 0 6.1 2.7 6.1 6.1v17.6c0 6.4-3.7 12.3-10.3 16.7-3.3 2.2-7.1 3.8-10.9 4.7V192h-12.1l-.1-23.9c-3.7-.9-7.6-2.5-10.9-4.7-6.7-4.4-10.3-10.3-10.3-16.7v-11c0-3.4 2.7-6.2 6.1-6.2z"
        />
        <path
          fill="#243038"
          d="M370.8 193h-14.1l-.1-24.2c-3.7-1-7.3-2.6-10.4-4.6-7-4.6-10.8-10.8-10.8-17.6v-11c0-3.9 3.2-7.1 7.1-7.1s7.1 3.2 7.1 7.1v11c0 2.7 3.4 5.4 7 7.1V98.3c0-3.9 3.2-7.1 7.1-7.1s7.1 3.2 7.1 7.1v42.2c3.6-1.7 7-4.4 7-7.1v-17.6c0-3.9 3.2-7.1 7.1-7.1s7.1 3.2 7.1 7.1v17.6c0 6.7-3.8 13-10.8 17.6-3.1 2-6.8 3.7-10.4 4.6V193zm-12.1-2h10.2v-36.9l.8-.2c3.7-.9 7.5-2.5 10.6-4.6 6.4-4.2 9.9-9.9 9.9-15.9v-17.6c0-2.8-2.3-5.1-5.1-5.1s-5.1 2.3-5.1 5.1v17.6c0 4.2-5.2 7.8-9.6 9.5l-1.4.5V98.3c0-2.8-2.3-5.1-5.1-5.1s-5.1 2.3-5.1 5.1v58.4l-1.4-.5c-4.4-1.8-9.6-5.3-9.6-9.5v-11c0-2.8-2.3-5.1-5.1-5.1s-5.1 2.3-5.1 5.1v11c0 6 3.5 11.7 9.9 15.9 3.1 2.1 6.9 3.7 10.6 4.6l.8.2-.2 23.6z"
        />
      </g>
      <g>
        <path
          fill="#243038"
          d="M125.4 231.6c-.4 0-.8-.2-.9-.6l-7.1-17.1 1.3-16.3 8.1-11.5 6.4-6.3c.4-.4 1-.4 1.4 0 .4.4.4 1 0 1.4l-6.4 6.2-7.6 10.9-1.2 15.3 6.9 16.7c.2.5 0 1.1-.5 1.3h-.4z"
        />
        <path
          fill="#243038"
          d="M127.5 187.8c-.5 0-.9-.3-1-.8-.1-.5.3-1.1.8-1.1l6-1c.5-.1 1.1.3 1.1.8.1.5-.3 1.1-.8 1.1l-6 1h-.1zM124 192.7c-.4 0-.7-.2-.9-.5l-2.2-4.2c-.3-.5-.1-1.1.4-1.4.5-.3 1.1-.1 1.4.4l2.2 4.2c.3.5.1 1.1-.4 1.4-.2 0-.3.1-.5.1zM119 207c-.2 0-.3 0-.5-.1-.5-.3-.6-.9-.4-1.4l5.2-8.8 4.5-2.5c.5-.3 1.1-.1 1.4.4.3.5.1 1.1-.4 1.4l-4 2.2-4.9 8.3c-.2.3-.6.5-.9.5z"
        />
        <path
          fill="#243038"
          d="M119.2 204.1c-.3 0-.7-.2-.9-.5l-3.8-6.2c-.3-.5-.1-1.1.3-1.4.5-.3 1.1-.1 1.4.3l3.8 6.2c.3.5.1 1.1-.3 1.4-.1.1-.3.2-.5.2zM127.5 201s0-.1 0 0l-4.8-.3c-.6 0-1-.5-.9-1.1s.5-1 1.1-.9l4.8.3c.6 0 1 .5.9 1.1-.1.4-.6.9-1.1.9zM122.7 225.1h-.2c-.5-.1-.9-.7-.7-1.2l4.1-15.9 8.6-11.7 9.6-6.1 6.9-2.7 2.9-5.3c.3-.5.9-.7 1.4-.4s.7.9.4 1.4l-3.3 5.9-7.5 2.9-9 5.7-8.1 11-4 15.5c-.3.6-.7.9-1.1.9zM119.6 217.7h-.2l-5-.9c-.5-.1-.9-.6-.8-1.2.1-.5.6-.9 1.2-.8l5 .9c.5.1.9.6.8 1.2-.1.5-.5.8-1 .8z"
        />
        <path
          fill="#243038"
          d="M145.1 233.8l-11.2-4.4-10.9-3c-.5-.1-.8-.7-.7-1.2.1-.5.7-.8 1.2-.7l11.1 3.1 10.5 4.1 10-4.1 8.6-4.3c.5-.2 1.1 0 1.3.5.2.5 0 1.1-.5 1.3l-8.7 4.3-10.7 4.4zM146.7 191.3c-.5 0-.9-.4-1-.9l-.4-4.6 4.3-5.5c.3-.4 1-.5 1.4-.2s.5 1 .2 1.4l-3.8 4.9.3 3.8c0 .5-.4 1-1 1.1zM136.6 197.1c-.5 0-1-.4-1-1v-5.3l2.8-5.4 2-3.6c.3-.5.9-.7 1.4-.4.5.3.7.9.4 1.4l-2 3.5-2.6 4.9v4.7c0 .7-.5 1.2-1 1.2zM125.9 212.6c-.3 0-.5-.1-.7-.3l-3.4-3.5c-.4-.4-.4-1 0-1.4.4-.4 1-.4 1.4 0l3.4 3.5c.4.4.4 1 0 1.4-.2.2-.4.3-.7.3zM124.4 218.6c-.3 0-.5-.1-.7-.3-.4-.4-.4-1 0-1.4l4.8-4.7 7.2-4 7.4-7.2c.4-.4 1-.4 1.4 0 .4.4.4 1 0 1.4l-7.7 7.5-7.2 4-4.5 4.4c-.2.2-.5.3-.7.3zM129.7 205.4c-.5 0-1-.4-1-1s.4-1 1-1l5.2-.1 2.7-2.7c.4-.4 1-.4 1.4 0 .4.4.4 1 0 1.4l-3.3 3.2-6 .2zM147.7 195.7l-5.9-2.2c-.5-.2-.8-.8-.6-1.3.2-.5.8-.8 1.3-.6l5.4 2 4.1-1c.5-.1 1.1.2 1.2.7.1.5-.2 1.1-.7 1.2l-4.8 1.2z"
        />
        <path
          fill="#243038"
          d="M145.7 224l-12.1-2-10-.3c-.6 0-1-.5-1-1s.5-1 1-1l10.2.3 11.6 1.9 12-4.7 6.1-7.3 5.2-5.6c.4-.4 1-.4 1.4 0 .4.4.4 1 0 1.4l-5.2 5.5-6.4 7.6-12.8 5.2z"
        />
        <path
          fill="#243038"
          d="M144.2 213.8l-7.9-.3-3.9-1.5c-.5-.2-.8-.8-.6-1.3.2-.5.8-.8 1.3-.6l3.6 1.4 6.4.2 4-6.3 3-6.8 6.8-4.4 2-4.1c.2-.5.8-.7 1.3-.5.5.2.7.8.5 1.3l-2.3 4.6-6.8 4.4-2.9 6.4-4.5 7.5z"
        />
        <path
          fill="#243038"
          d="M139.2 207.2c-.1 0-.3 0-.4-.1-.5-.2-.8-.8-.5-1.3l2.1-5.3 2.5-4.7c.3-.5.9-.7 1.4-.4.5.3.7.9.4 1.4l-2.4 4.6-2.1 5.2c-.2.4-.6.6-1 .6zM132.1 228.9c-.4 0-.7-.2-.9-.6-.2-.5 0-1.1.5-1.3l6.2-2.8 3.8 2.2c.5.3.6.9.4 1.4-.3.5-.9.6-1.4.4l-2.9-1.7-5.3 2.4h-.4zM153.9 230.2c-.1 0-.2 0-.4-.1-.5-.2-.8-.8-.6-1.3l1.8-4.5 6.1-3.4 2.9-4.1 3.7-2.3c.5-.3 1.1-.1 1.4.3.3.5.1 1.1-.3 1.4l-3.4 2.1-2.9 4.1-5.9 3.3-1.5 3.9c-.1.3-.5.6-.9.6z"
        />
        <path
          fill="#243038"
          d="M138.3 235.2c-.4 0-.8-.3-1-.7l-1.4-4.7c-.2-.5.1-1.1.7-1.2.5-.2 1.1.1 1.2.7l1.4 4.7c.2.5-.1 1.1-.7 1.2h-.2zM130.2 221.9c-.3 0-.5-.1-.7-.3-.4-.4-.4-1 0-1.4l3.7-3.6 8.2 1.1 5.9-1.8 3.7-1.6 4-6 3.8-9.2 4.4-2.9 3.9.7c.5.1.9.6.8 1.2s-.6.9-1.2.8l-3.2-.6-3.2 2.1-3.7 8.9-4.4 6.6-4.4 1.9-6.4 2-7.7-1.1-3 2.9c0 .2-.3.3-.5.3z"
        />
        <path
          fill="#243038"
          d="M148 207c-.5 0-.9-.4-1-.9-.1-.5.3-1 .9-1.1l2.6-.3 3.6-3.5c.4-.4 1-.4 1.4 0 .4.4.4 1 0 1.4l-4.1 4-3.3.4h-.1zM147.6 217.8h-.2c-.5-.1-.9-.6-.8-1.2l1-5.3 3.8-3.7c.4-.4 1-.4 1.4 0 .4.4.4 1 0 1.4l-3.3 3.2-.8 4.7c-.2.6-.6.9-1.1.9zM156.5 208.2c-.5 0-.9-.3-1-.8-.1-.5.3-1.1.8-1.2l3.5-.6 3.1-3 3.4.2c.6 0 1 .5.9 1.1 0 .6-.5 1-1.1.9l-2.5-.1-2.9 2.9-4.2.7c.1-.1.1-.1 0-.1zM149.8 227.1c-.2 0-.4-.1-.6-.2l-4.2-3.2c-.4-.3-.5-1-.2-1.4.3-.4 1-.5 1.4-.2l4.2 3.2c.4.3.5 1 .2 1.4-.2.3-.5.4-.8.4zM155.9 219.8h-.3c-.5-.2-.8-.7-.6-1.3l1.2-3.7 2.5-4.9c.2-.5.8-.7 1.3-.4.5.2.7.8.4 1.3l-2.4 4.9-1.1 3.5c-.1.4-.5.6-1 .6zM169.4 212.1h-.1l-5.1-.6c-.5-.1-.9-.6-.9-1.1.1-.5.6-.9 1.1-.9l5.1.6c.5.1.9.6.9 1.1-.1.5-.5.9-1 .9z"
        />
      </g>
      <path
        fill="#243038"
        d="M190.9 172.8H13.4l29-15.8c.3-.2.5-.5.5-.8V89c0-1.3.5-2.5 1.4-3.4l3.8-3.8c.9-.9 2.1-1.4 3.4-1.4H96c1.7 0 3.2.9 4.1 2.3l5.6 9.3c.4.7.7 1.6.7 2.5v36.8c0 .5.4.9.9.9h5.2c2 0 3.7 1.2 4.4 3l4.6 11.7c.1.3.5.6.8.6h3.3v-46.3c0-.7.2-1.5.5-2.1l1.8-3.5c.8-1.6 2.4-2.6 4.3-2.6h5.3c2.1 0 4 1.4 4.6 3.4l1.4 4.8c.1.4.2.9.2 1.4V136c0 1 .5 1.8 1.3 2.3l4.6 2.9 11.6 5.4c.4.2.8.5 1 .8l8.2 10.4c.1.1.3.2.4.3l14.7 4.4 5.4 10.3zm-169.6-2h166.3l-3.5-6.6-13.9-4.1c-.6-.2-1.1-.5-1.4-1l-8.2-10.4-.3-.3-11.7-5.5-4.7-2.9c-1.4-.9-2.2-2.4-2.2-4v-33.5c0-.3 0-.5-.1-.8l-1.4-4.8c-.4-1.2-1.4-2-2.6-2h-5.3c-1.1 0-2 .6-2.5 1.5l-1.8 3.5c-.2.4-.3.8-.3 1.2v48.3h-5.3c-1.2 0-2.2-.7-2.7-1.8L115 136c-.4-1.1-1.4-1.8-2.6-1.8h-5.2c-1.6 0-2.9-1.3-2.9-2.9V94.5c0-.5-.1-1-.4-1.4l-5.6-9.3c-.5-.8-1.4-1.3-2.4-1.3H51.4c-.7 0-1.4.3-2 .8l-3.8 3.8c-.5.5-.8 1.2-.8 2v67.2c0 1.1-.6 2-1.5 2.5l-22 12z"
      />
      <g>
        <path
          fill="#abc885"
          d="M241 91.3c-5.7 0-10.3 4.6-10.3 10.3V120c0 5.7-7.4 11.4-15 14.4V39c0-5.7-4.6-10.3-10.3-10.3s-10.3 4.6-10.3 10.3v73.3c-7.7-3-15-8.7-15-14.4V68.4c0-5.7-4.6-10.3-10.3-10.3-5.7 0-10.3 4.6-10.3 10.3v29.4c0 10.7 6.2 20.7 17.3 28 5.5 3.6 12 6.4 18.2 7.9V196h20.4l.2-40.1c6.3-1.5 12.7-4.2 18.2-7.9 11.2-7.4 17.3-17.3 17.3-28v-18.4c.2-5.7-4.4-10.3-10.1-10.3z"
        />
        <path
          fill="#243038"
          d="M216.6 197h-22.4v-62.4c-6.2-1.6-12.5-4.4-17.8-7.8-11.5-7.6-17.8-17.8-17.8-28.9V68.4c0-6.2 5.1-11.3 11.3-11.3s11.3 5.1 11.3 11.3v29.4c0 5 6.5 10 13 12.9V39c0-6.2 5.1-11.3 11.3-11.3s11.3 5.1 11.3 11.3v93.9c6.5-2.9 13-7.9 13-12.9v-18.4c0-6.2 5.1-11.3 11.3-11.3s11.3 5.1 11.3 11.3V120c0 11.1-6.3 21.3-17.8 28.9-5.3 3.5-11.5 6.2-17.8 7.8l-.2 40.3zm-20.4-2h18.4l.2-39.9.8-.2c6.3-1.5 12.6-4.3 17.9-7.7 10.9-7.2 16.9-16.8 16.9-27.2v-18.4c0-5.1-4.2-9.3-9.3-9.3-5.1 0-9.3 4.2-9.3 9.3V120c0 6.3-7.9 12.3-15.7 15.4l-1.4.5V39c0-5.1-4.2-9.3-9.3-9.3-5.1 0-9.3 4.2-9.3 9.3v74.8l-1.4-.5c-7.8-3.1-15.7-9-15.7-15.4V68.4c0-5.1-4.2-9.3-9.3-9.3s-9.3 4.2-9.3 9.3v29.4c0 10.4 6 20 16.9 27.2 5.3 3.5 11.6 6.2 17.9 7.7l.8.2V195z"
        />
      </g>
    </InlineSVG>
  )
}
