/*
 * Copyright (C) 2020 - present Instructure, Inc.
 *
 * This file is part of Canvas.
 *
 * Canvas is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License as published by the Free
 * Software Foundation, version 3 of the License.
 *
 * Canvas is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 */
import React from 'react'
import I18n from 'i18n!TourPoints'
import {Link} from '@instructure/ui-link'
import {Text} from '@instructure/ui-text'
import {View} from '@instructure/ui-view'
import {Heading} from '@instructure/ui-heading'
import {ScreenReaderContent} from '@instructure/ui-a11y'
import handleOpenTray from '../handleOpenTray'
import assetFactory from 'jsx/celebrations/assetFactory'

export default [
  {
    selector: '#global_nav_help_link',
    content: () => (
      <section>
        {/* Hide the overlay on the first step. */}
        <style>
          {`#___reactour svg rect {
            opacity:0;
          }`}
        </style>
        <Heading level="h3">
          {I18n.t(`Hello%{name}!`, {
            name: window.ENV?.current_user?.display_name
              ? `, ${window.ENV?.current_user?.display_name}`
              : ''
          })}
        </Heading>
        <Text as="p">
          {I18n.t(
            'We know getting your courses online quickly during this time is priority. This quick tour will show you how to:'
          )}
        </Text>
        <ol>
          <li>
            <Link
              as="a"
              href="https://community.canvaslms.com/t5/Instructor-Guide/How-do-I-set-my-Canvas-notification-preferences-as-an-instructor/ta-p/1222"
              target="_blank"
              rel="noopener noreferrer"
            >
              {I18n.t('Set up your Notifications')}
            </Link>
          </li>
          <li>
            <Link
              as="a"
              href="https://community.canvaslms.com/t5/Contingency-Planning/Set-Up-Your-Canvas-Course-in-30-minutes-or-Less/ba-p/258437"
              target="_blank"
              rel="noopener noreferrer"
            >
              {I18n.t('Get your Content online')}
            </Link>
          </li>
          <li>
            <Link
              as="a"
              href="https://community.canvaslms.com/t5/Instructor-Guide/How-do-I-create-a-conference-in-a-course/ta-p/1156"
              target="_blank"
              rel="noopener noreferrer"
            >
              {I18n.t('Learn more about Video Conferencing')}
            </Link>
            <ul>
              <li>
                <Link
                  as="a"
                  href="https://community.canvaslms.com/t5/Admin-Group/Using-Zoom-with-Canvas-FAQ/ba-p/261826"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  Zoom
                </Link>
              </li>
              <li>
                <Link
                  as="a"
                  href="https://community.canvaslms.com/t5/Admin-Group/Google-Hangouts-Meet-LTI/ba-p/257649"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  Google Meet
                </Link>
              </li>
              <li>
                <Link
                  as="a"
                  href="https://www.youtube.com/watch?v=zUXXeiRCFfY"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  Microsoft Teams
                </Link>
              </li>
            </ul>
          </li>
        </ol>
        <div className="tour-star-image" aria-hidden>
          <img src={assetFactory('star')} alt={I18n.t('star')} />
        </div>
      </section>
    )
  },
  {
    observe: '.profile-tab-notifications',
    selector: '.profile-tab-notifications',
    content: (
      <section>
        <Heading level="h3">{I18n.t('Set Up Your Notifications')}</Heading>
        <ScreenReaderContent>
          {I18n.t('Click on the account navigation button to access notification preferences.')}
        </ScreenReaderContent>
        <Text as="p">
          <Link
            as="a"
            href="https://community.canvaslms.com/t5/Instructor-Guide/How-do-I-set-my-Canvas-notification-preferences-as-an-instructor/ta-p/1222"
            target="_blank"
            rel="noopener noreferrer"
          >
            {I18n.t("Don't miss notifications from your students.")}
          </Link>
        </Text>
        <iframe
          title={I18n.t('Canvas Notifications Tutorial Video')}
          src="https://player.vimeo.com/video/75514816?title=0&byline=0&portrait=0"
          width="100%"
          height="277px"
          style={{marginTop: '1rem'}}
          frameBorder="0"
          allow="autoplay; fullscreen"
          allowFullScreen
        />
      </section>
    ),
    actionBefore: async () => {
      await handleOpenTray('profile')
    }
  },
  {
    selector: '.navigation-tray-container',
    content: (
      <section>
        <Heading level="h3">{I18n.t('Get Your Content Online Quickly')}</Heading>
        <ScreenReaderContent>
          {I18n.t('Click on the courses navigation button to access your courses.')}
        </ScreenReaderContent>
        <Text as="p">
          <Link
            as="a"
            href="https://community.canvaslms.com/t5/Contingency-Planning/Set-Up-Your-Canvas-Course-in-30-minutes-or-Less/ba-p/258437"
            target="_blank"
            rel="noopener noreferrer"
          >
            {I18n.t('Set up your Canvas course in 30 minutes or less.')}
          </Link>
        </Text>
        <iframe
          title={I18n.t('Canvas Course Tutorial Video')}
          src="https://player.vimeo.com/video/69658934?title=0&byline=0&portrait=0"
          width="100%"
          height="277px"
          style={{marginTop: '1rem'}}
          frameBorder="0"
          allow="autoplay; fullscreen"
          allowFullScreen
        />
      </section>
    ),
    actionBefore: async () => {
      await handleOpenTray('courses')
    }
  },
  {
    selector: '.navigation-tray-container',
    content: (
      <section>
        <Heading level="h3">{I18n.t('Learn more about Video Conferencing')}</Heading>
        <View as="div" margin="small 0 0 0">
          <ul>
            <li>
              <Link
                as="a"
                href="https://community.canvaslms.com/t5/Admin-Group/Using-Zoom-with-Canvas-FAQ/ba-p/261826"
                target="_blank"
                rel="noopener noreferrer"
              >
                Zoom
              </Link>
            </li>
            <li>
              <Link
                as="a"
                href="https://community.canvaslms.com/t5/Admin-Group/Google-Hangouts-Meet-LTI/ba-p/257649"
                target="_blank"
                rel="noopener noreferrer"
              >
                Google Meet
              </Link>
            </li>
            <li>
              <Link
                as="a"
                href="https://www.youtube.com/watch?v=zUXXeiRCFfY"
                target="_blank"
                rel="noopener noreferrer"
              >
                Microsoft Teams
              </Link>
            </li>
            <li>
              <Link
                as="a"
                href="https://community.canvaslms.com/t5/Instructor-Guide/How-do-I-create-a-conference-in-a-course/ta-p/1156"
                target="_blank"
                rel="noopener noreferrer"
              >
                {I18n.t('More Video Conferencing Tools')}
              </Link>
            </li>
          </ul>
        </View>
      </section>
    ),
    actionBefore: async () => {
      await handleOpenTray('help')
    }
  }
]
