/*
 * Copyright (C) 2017 - present Instructure, Inc.
 *
 * This file is part of Canvas.
 *
 * Canvas is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License as published by the Free
 * Software Foundation, version 3 of the License.
 *
 * Canvas is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 */

import React from 'react'

export default function ActAsMask() {
  return (
    <svg viewBox="0 0 129 157" className="ActAs__mask">
      <path
        className="ActAs__mask-1"
        d="M64.8 155.21a11 11 0 0 1-11.07-10.93l-.61-90.51a11 11 0 0 1 22-.15l.61 90.51a11 11 0 0 1-10.93 11.08z"
      />
      <path
        className="ActAs__mask-2"
        d={
          'M53.15 58.29c4.24 23 13.08 74.25 11.65 96.92M53.33 86s11.42 39.3 8.25 68.8M59.49 ' +
          '43.73c1.81 26.17 15 88.83 11.78 109.31M68.6 43.67c0 19.18 1.07 55.51 6.95 74.47M53.55 ' +
          '118.29c3.17 12.31 5.65 22.86 2.84 33.1'
        }
      />
      <path
        className="ActAs__mask-3"
        d="M118 66.4l-.35-51.69A9.5 9.5 0 0 0 102.74 7L64.32 33.51zM11.1 67.12l-.35-51.69a9.5 9.5 0 0 1 14.8-8l38.77 26z"
      />
      <path className="ActAs__mask-4" d="M19.36 23l.27 40.82M108.81 22.4l.27 40.82" />
      <path className="ActAs__mask-5" d="M114.44 85.9a53.44 53.44 0 1 0-99.8 0z" />
      <path
        className="ActAs__mask-6"
        d="M108.25 85.9A19.87 19.87 0 0 0 97.6 64.29C83.15 57 68.53 50.16 64.43 50.19s-18.62 7-33 14.55A19.86 19.86 0 0 0 21 85.9z"
      />
      <path d="M59.93 81.26l-5.57-7A6 6 0 0 1 59 64.55l11.06-.07a6 6 0 0 1 4.77 9.69l-5.48 7a6 6 0 0 1-9.42.09z" />
      <path className="ActAs__mask-7" d="M59.83 70.82l9.48-.06" />
      <path
        className="ActAs__mask-8"
        d="M100.62 85.9c3.41-14.09 1.06-28-.91-33.89l-22 8.26c4.36 9.73 9.6 17.3 10.57 25.63z"
      />
      <circle
        className="ActAs__mask-8"
        cx="88.23"
        cy="55.26"
        r="12"
        transform="rotate(-.39 87.962 54.657)"
      />
      <path d="M88.23 63.67a8.39 8.39 0 1 1 .06 0z" />
      <path
        className="ActAs__mask-6"
        d={
          'M88.24 47.34a7.92 7.92 0 0 1 .05 15.83h-.05a7.92 7.92 0 0 1-.05-15.83h.05m0-1h-.06a8.92 ' +
          '8.92 0 0 0 .06 17.83h.06a8.92 8.92 0 0 0-.06-17.83z'
        }
      />
      <circle
        className="ActAs__mask-6"
        cx="78.23"
        cy="42.71"
        r="4.65"
        transform="rotate(-.39 77.718 42.87)"
      />
      <path
        className="ActAs__mask-8"
        d="M41.1 85.9c.95-8.22 6-15.8 10.19-25.45l-22.11-8c-1.87 5.82-4 19.54-.58 33.41z"
      />
      <circle
        className="ActAs__mask-8"
        cx="40.7"
        cy="55.58"
        r="12"
        transform="rotate(-.39 40.95 54.497)"
      />
      <path d="M40.7 64a8.39 8.39 0 1 1 .06 0z" />
      <path
        className="ActAs__mask-6"
        d={
          'M40.7 47.66a7.92 7.92 0 0 1 .05 15.83h-.05a7.92 7.92 0 0 1-.05-15.83h.05m0-1h-.06a8.92 ' +
          '8.92 0 0 0 .06 17.83h.06a8.92 8.92 0 0 0-.06-17.83z'
        }
      />
      <circle
        className="ActAs__mask-6"
        cx="50.53"
        cy="42.9"
        r="4.65"
        transform="rotate(-.39 49.805 42.774)"
      />
      <circle
        className="ActAs__mask-9"
        cx="90.83"
        cy="52.62"
        r="2.62"
        transform="rotate(-.39 89.441 51.724)"
      />
      <circle
        className="ActAs__mask-9"
        cx="42.83"
        cy="52.95"
        r="2.62"
        transform="rotate(-.39 42.424 53.033)"
      />
      <path className="ActAs__mask-10" d="M114.44 85.9a53.44 53.44 0 1 0-99.8 0z" />
    </svg>
  )
}
